<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\Style\Font;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    $racefilter = "";
    //if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
    //    $racefilter = " AND RA.id BETWEEN " . $_REQUEST["raceidfrom"] . " AND " . $_REQUEST["raceidto"] . " ";
    //}
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }
    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $reuniondate = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];
    $ordinal = ["Primera", "Segunda", "Tercera", "Cuarta", "Quinta", "Sexta", "Séptima", "Octava", "Novena", "Décima"];
    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid<>0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "S" . $rcabbr  . "C" . $row["num"] . "." . $outputformat;

    // Armar arreglo con jugadas de pool de 4 y loto hipico
    $sql =  "SELECT     number, JSON_EXTRACT(RA.bets, '$[*].id') bet " .
            "FROM       races RA " . 
            "WHERE      RA.reunionid = " . $reunionid . " " . 
            "ORDER BY   RA.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $pool4 = array();
    $superfecta = array();
    $dobperfecta = array();
    $lotohip = array();
    $tripleap = array();
    $cnt2p = 0;
    $cntp4 = 0;
    $cntlh = 0;
    $cntta = 0;
    while ($row = $rs->fetch_assoc()){
        // se busca 5 que es el id de superfecta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "5"))
            $superfecta[$row["number"]] = 1;
        else
            $superfecta[$row["number"]] = 0;
        // se busca 6 que es el id de soble perfecta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "6"))
            if ($cnt2p<2)
                $cnt2p++;
            else
                $cnt2p = 1;
        else
            $cnt2p=0;
        $dobperfecta[$row["number"]] = $cnt2p;
        // se busca 7 que es el id de pool de 4
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "7"))
            if ($cntp4<4)
                $cntp4++;
            else
                $cntp4 = 1;
        else
            $cntp4=0;
        $pool4[$row["number"]] = $cntp4;
        // se busca 8 que es el id de loto hipico
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "8"))
            if ($cntlh<2)
                $cntlh++;
            else
                $cntlh = 1;
        else
            $cntlh=0;
        $lotohip[$row["number"]] = $cntlh;
        // se busca 9 que es el id de triple apuesta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "9"))
            if ($cntta<2)
                $cntta++;
            else
                $cntta = 1;
        else
            $cntta=0;
        $tripleap[$row["number"]] = $cntta;
    }

    $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
    // calcular inicio del cuatrimestre
    $actualmonth = intval(date('m', strtotime($date)));
    if ($actualmonth <= 4)
        $datefrom4 = "01";
    else if ($actualmonth <= 8)
        $datefrom4 = "05";
    else if ($actualmonth <= 12)
        $datefrom4 = "09";
    $datefrom4 = date('Y', strtotime($date)) . "-" . $datefrom4 . "-01";
    // SOlo para Caracas
    if ($racecourseid == 2)
        $datefrom = $datefrom4;
    $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
    $sql =  "SELECT     C.id horseid, R.id racerid, H.dsc racecourse, RA.extraprice, CU1.symbol pricecurr, CU2.symbol extrapricecurr, DATE_FORMAT(RE.date, '%d/%m/%y') fecha, " .
            "           H.id racecourseid, RA.id raceid, RA.ord raceord, RA.number racenumber, RA.mainprice, RA.firstplace, RA.secondplace, RA.thirdplace, RA.fourthplace, RA.fifthplace, " .
            "           RA.additionalprice, RA.pricesformat, " .
            "           R.number horsenumber, R.position horseposition, C.gender, FU.abbr furabbr, CEILING(DATEDIFF(RE.date, CONCAT(YEAR(C.birthdate), '-12-31'))/365.25) age, R.jockeyweight, RA.valid, " .
            "           RE.date reuniondate, D.id distid, D.dsc distancia, RT.id racetypeid, RT.dsc racetypedsc, " .
            "           REPLACE(LOWER(DATE_FORMAT(RA.time, '%h:%i %p')),'m','.m.') hora, DAYOFWEEK(RE.date) dow, " .
            "           CO1.dsc condicion1, CO2.dsc condicion2, RA.conditiondsc, " .
            "           RH.horsename recordhorse, RH.jockeyname recordjockey, RH.jockeyweight recordweight, RH.basetime recordtime,  " .
            "           DATE_FORMAT(RH.date, '%d/%m/%y') recorddate, " .
            "           S.dsc studname, S.abbr studabbr, " .
            "           C.obs horseobs, C.dsc horsename, C.mothergfname horsegfather, C.fathername horsefather, C.mothername horsemother, DATE_FORMAT(C.birthdate, '%d/%m/%y') horsebirth, " .
            "           J.abbr jockeyname, T.abbr trainername, ROUND(IF(SJ.jockeytotal<>0, SJ.jockeyfirst/SJ.jockeytotal*100,0),0) xx, ROUND(SJ.rend,0) jockeyef, " . 
            "           ROUND(IF(ST.trainertotal<>0, ST.trainerfirst/ST.trainertotal*100,0),0) xxx, ROUND(ST.rend,0) traineref, " . 
            "           IFNULL(R.implementstypeM, '') medicaments, IFNULL(R.implementstypeI,'') implements, " .
            "           IFNULL(F.racers,'') forecastracers, F.top3, F.top6, " .
            "           IFNULL(FGH.racers,'') forecastracersGH, FGH.top3 top3GH, FGH.top6 top6GH, " .
            //"           SH.pricebs, SH.totalraces, SH.firstplace totalwin, SH.totalracesyear, SH.firstplaceyear totalwinyear, " .
            "           SA.harasname, SA.pricesbs harasbs " .
            "FROM       racers R  " .
            "INNER JOIN races RA  " .
            "ON         R.raceid=RA.id " .
            "INNER JOIN racetypes RT " . 
            "ON         RA.racetypeid=RT.id " .
            "INNER JOIN reunions RE  " .
            "ON         RA.reunionid=RE.id " .
            "INNER JOIN racecourses H  " .
            "ON         RE.racecourseid=H.id " .
            "INNER JOIN conditions CO1 " .
            "ON         RA.conditionid1=CO1.id " .
            "INNER JOIN conditions CO2 " .
            "ON         RA.conditionid2=CO2.id " .
            "INNER JOIN distances D  " .
            "ON         RA.distanceid=D.id " .
            "LEFT JOIN	(SELECT * FROM records_hipdst WHERE deleted IS NULL) RH " .
            "ON			RE.racecourseid=RH.racecourseid " .
            "AND		RA.distanceid=RH.distanceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " .
            "ON         RA.id=F.raceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=3) FGH " .
            "ON         RA.id=FGH.raceid " .
            "INNER JOIN studs S  " .
            "ON			R.studid=S.id " .
            "INNER JOIN horses C  " .
            "ON			R.horseid=C.id " .
            "INNER JOIN furs FU " . 
            "ON         C.furid=FU.id " .
            "INNER JOIN stats_haras SA " .
            "ON         C.harasid=SA.harasid " .
            "INNER JOIN jockeys J  " .
            "ON			R.jockeyid=J.id " .
            "INNER JOIN	trainers T  " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN currencies CU1 " .
            "ON         RA.mainpricecurr=CU1.code " .
            "INNER JOIN currencies CU2 " .
            "ON         RA.extrapricecurr=CU2.code " .
            //"LEFT JOIN  ( " .
            //"            SELECT		horseid, SUM(firstplace) firstplace, SUM(totalraces) totalraces,  " .
            //"                       SUM(firstplaceyear) firstplaceyear, SUM(totalracesyear) totalracesyear, SUM(pricesbs) pricebs  " .
            //"            FROM		(SELECT H.* FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_horses H) H " .
            //"            GROUP BY   horseid " .
            //"           )  SH " .
            //"ON         R.horseid = SH.horseid " .
//            "AND        RE.racecourseid = SH.racecourseid " .
//            "AND        RA.distanceid = SH.distanceid " .
            "LEFT JOIN  (SELECT J.jockeyid, J.racecourseid, J.totalraces jockeytotal, J.firstplace jockeyfirst, J.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_jockeys J) SJ " . 
            "ON         R.jockeyid=SJ.jockeyid " . 
            "AND        RE.racecourseid=SJ.racecourseid " .
            "LEFT JOIN  (SELECT T.trainerid, T.racecourseid, T.totalraces trainertotal, T.firstplace trainerfirst, T.rend FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_trainers T) ST " . 
            "ON         R.trainerid=ST.trainerid " . 
            "AND        RE.racecourseid=ST.racecourseid " .
            "WHERE      RE.id=" . $reunionid . " " .
            "AND        RA.valid<>0 " .
            $racefilter .
            //"AND        RE.number=49 " .
            "ORDER BY   RA.ord, R.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $phpWord = new PhpWord();
    $phpWord->getCompatibility()->setOoxmlVersion(15);

    // medidas
    $pulgada = 1440;
    $height = 8.28*$pulgada; //7.28*$pulgada;  // 1440 twip = 1 pulgada
    $width = 4.8*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    // colores
    $negro = "000000";
    $gris = "CECECE";
    $verde = "849966";
    $verdeclaro = "dcdfcc";
    //if ($racecourseid == 4){
    //    $fondo = $verde;
    //    $fondoclaro = $verdeclaro;
    //}else{
        $fondo = $negro;
        $fondoclaro = $gris;
    //}

    // Ancho de las columnas
    $C1 =  0.04;
    $C2 =  0.225;
    $C3 =  0.105; //+C19
    $C4 =  0.03;
    $C5 =  0.03;
    $C6 =  0.04;
    $C7 =  0.03;
    $C8 =  0.03;
    $C9 =  0.03;
    $C10 = 0.03;
    $C11 = 0.03;
    $C12 = 0.13;
    $C13 = 0.11;
    $C14 = 0.04;
    $C15 = 0.04;
    $C16 = 0; //0.03;
    $C17 = 0.03;
    $C18 = 0.03;
    $C19 = 0; //0.02;
    $anchoHistoria = $width*($C5+$C6+$C7+$C8+$C9+$C10+$C11+$C12+$C13+$C14+$C15+$C16+$C17+$C18+$C19);

    $borderwidth = 6;
    // ESTILOS
    // Estilos de celdas
    $headerCellFullBrdStyle = [
        "valign" => "bottom",
        "borderSize" => $borderwidth,
        "borderColor" => "000000",
    ];
    $headerCellTopDwnBrdStyle = [
        "valign" => "bottom",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => '000000',
        "borderRightSize" => $borderwidth,
        "borderRightColor" => 'FFFFFF',
        "borderLeftSize" => $borderwidth,
        "borderLeftColor" => 'FFFFFF',
    ];
    $headerCellRightBrdStyle = [
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => "000000",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderLeftSize" => $borderwidth,
        "borderLeftColor" => 'FFFFFF',
    ];
    $headerCellStyle = [
        //"bgColor"=>$fondoclaro,
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => 0,
        "borderBottomSize" => 0,
        "borderLeftSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];

    $betsAreaCellStyle = [
        "bgColor"=>"FFFFFF",
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $betsInvAreaCellStyle = [
        "bgColor"=>"000000",
        "valign" => "center",
        "borderColor" => "000000",
        "borderSize" => 1,
        //"borderStyle" => Border::NONE,
    ];

    $detailCellStyle = [
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => "FFFFFF",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        //"borderStyle" => Border::NONE,
    ];

    $detailSpan12CellStyle = [
        "gridSpan"=> 12,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailSpan2CellStyle = [
        "gridSpan"=>2,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $statsAreaCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $cuartoFavCellStyle = [
        "valign" => "bottom",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $topRightBoxLeftCellStyle = [
        "valign" => "center",
        "borderLeftSize" => 6,
        "borderTopSize" => 6,
        "borderBottomSize" => 6,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $topRightBoxLeftInvCellStyle = [
        "valign" => "center",
        "bgColor" => "000000",
        "borderColor" => "000000",
        "borderRightStyle" => Border::NONE,
    ];
    $topRightBoxRightCellStyle = [
        "valign" => "top",
        "borderRightSize" => 6,
        "borderTopSize" => 6,
        "borderBottomSize" => 6,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];

    $detailCellStyleFullBrd = [
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyleFullBrd = [
        "gridSpan" => 13,
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyle = [
        "gridSpan" => 13,
        "valign" => "top",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $defaultCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE
    ];
    $defaultBorderCellStyle = [
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $sloganCellStyle = [
        "valign" => "center",
        "bgColor" => "FFFFFF",
        "borderSize" => $borderwidth,
        //"borderStyle" => Border::NONE,
    ];
    $sloganInvCellStyle = [
        "valign" => "center",
        "bgColor" => "000000",
        "borderSize" => $borderwidth,
        //"borderStyle" => Border::NONE,
    ];

    // Estilos de Tablas
    $defaultTableFullWidthStyle = "defaultTableFullWidthStyle";
    $phpWord->addTableStyle($defaultTableFullWidthStyle,[
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $defaultCellStyle, $defaultCellStyle);
    $defaultTableFullWidthBorderStyle = "defaultTableFullWidthBorderStyle";
    $phpWord->addTableStyle($defaultTableFullWidthBorderStyle,[
            "width" => $width,
            "borderSize" => 6,
            "borderColor" => "000000",
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 6,
            "cellSpacing" => 0,
        ], $defaultBorderCellStyle, $defaultBorderCellStyle);
    $defaultTableHalfWidthStyle = "defaultTableHalfWidthStyle";
    $phpWord->addTableStyle($defaultTableHalfWidthStyle,[
            "width" => $width/2,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);

    $betsTableStyle = "betsTableStyle";
    $phpWord->addTableStyle($betsTableStyle,[
            "width" => $width/2*0.17,
            "bgColor"=>"FFFFFF",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsAreaCellStyle, $betsAreaCellStyle);
    $betsInvTableStyle = "betsInvTableStyle";
    $phpWord->addTableStyle($betsInvTableStyle,[
            "width" => $width/2*0.17,
            "bgColor"=>"000000",
            "borderColor" => "000000",
            "borderSize" => 1,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsInvAreaCellStyle, $betsInvAreaCellStyle);

    $defaultTableHstWidthStyle = "defaultTableHstWidthStyle";
    $phpWord->addTableStyle($defaultTableHstWidthStyle,[
            "width" => $anchoHistoria,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);


    // cintillo superior de premio en dolares
    $initialBannerText = "initialBannerText";
    $phpWord->addFontStyle($initialBannerText, [
        //"name"=>"Times New Roman",
        "name"=>"Arial Black",
        "size"=>12,
        "scale"=>120,
        "italic"=>true,
        "bold"=>false,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $initialBannerPar = "initialBannerPar";
    $phpWord->addParagraphStyle($initialBannerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        //"shading"=>["fill"=>$fondo],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Clásico
    $classicText = "classicText";
    $phpWord->addFontStyle($classicText, [
        "name"=>"Univers 65",
        "size"=>9,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $classicPar = "classicPar";
    $phpWord->addParagraphStyle($classicPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
        // Jugadas
        $bets1Text = "bets1Text";
        $phpWord->addFontStyle($bets1Text, [
            //"name"=>"Univers 65",
            //"name"=>"Arial Rounded MT Bold",
            "name"=>"Univers 65",
            "size"=>50,
            "spacing"=>-30,
            "scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"FFFFFF"
        ]);
        $bets1Par = "bets1Par";
        $phpWord->addParagraphStyle($bets1Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>-50,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $bets1smlText = "bets1smlText";
        $phpWord->addFontStyle($bets1smlText, [
            //"name"=>"Univers 65",
            //"name"=>"Arial Rounded MT Bold",
            "name"=>"Univers 65",
            "size"=>8,
            "spacing"=>-5,
            //"scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"FFFFFF"
        ]);
        $betssml1Par = "betssml1Par";
        $phpWord->addParagraphStyle($betssml1Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $bets2smlText = "bets2smlText";
        $phpWord->addFontStyle($bets2smlText, [
            //"name"=>"Univers 65",
            //"name"=>"Arial Rounded MT Bold",
            "name"=>"Univers 65",
            "size"=>11,
            "spacing"=>-10,
            "scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ]);
        $betssml2Par = "betssml2Par";
        $phpWord->addParagraphStyle($betssml2Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>-20,
            "spaceBefore"=>40,
            "spaceAfter"=>40,
        ]);
    // nombre del hipodromo
    $racecourseText = "racecourseText";
    $phpWord->addFontStyle($racecourseText, [
        "name"=>"Univers Extra Black",
        "size"=>12,
        "scale"=>80,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $racecoursePar = "racecoursePar";
    $phpWord->addParagraphStyle($racecoursePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', $width/4)
        ]
    ]);
    // fecha y hora de la carrera
    $dateText = "dateText";
    $phpWord->addFontStyle($dateText, [
        "name"=>"Univers 55",
        "size"=>8,
        "scale"=>95,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"scale" => 150
    ]);
    // fecha y hora de la carrera
    $timeText = "timeText";
    $phpWord->addFontStyle($timeText, [
        "name"=>"Univers 55",
        "size"=>8,
        "scale"=>95,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"scale" => 150
    ]);
    $datePar = "datePar";
    $phpWord->addParagraphStyle($datePar, [
        "spacing"=>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', $width*0.08),
                    new \PhpOffice\PhpWord\Style\Tab('right', $width*0.19)
        ]
    ]);
    $timePar = "timePar";
    $phpWord->addParagraphStyle($timePar, [
        "spacing"=>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', $width*0.08),
        ]
    ]);


    // Cuarto Favorito
    $cuartoFavText = "cuartoFavText";
    $phpWord->addFontStyle($cuartoFavText, [
        "name"=>"Univers 55",
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>true,
        "color"=>"000000"
    ]);
    $cuartoFavPar = "cuartoFavPar";
    $phpWord->addParagraphStyle($cuartoFavPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', (($width/2)+(($width/2)*0.17))/2)
        ]
    ]);
    // Cambio de Implementos
    $impchBoldText = "impchBoldText";
    $phpWord->addFontStyle($impchBoldText, [
        //"name"=>"Univers 55",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 55",
        "scale"=>100,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $impchText = "impchText";
    $phpWord->addFontStyle($impchText, [
        //"name"=>"Univers 55",
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $impchredText = "impchredText";
    $phpWord->addFontStyle($impchredText, [
        //"name"=>"Univers 55",
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>5.5,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $impchred2Text = "impchred2Text";
    $phpWord->addFontStyle($impchred2Text, [
        //"name"=>"Univers 55",
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $impchPar = "impchPar";
    $phpWord->addParagraphStyle($impchPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $impchredPar = "impchredPar";
    $phpWord->addParagraphStyle($impchredPar, [
        "spacing"=>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', (($width/2)+(($width/2)*0.17))/2)
        ]
    ]);
    $impchred2Par = "impchred2Par";
    $phpWord->addParagraphStyle($impchred2Par, [
        "spacing"=>-40,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', (($width/2)+(($width/2)*0.17))/2)
        ]
    ]);
    // tablas de yuntas y los mejores
    $separadorText = "separadorText";
    $phpWord->addFontStyle($separadorText, [
        "name"=>"Univers 55",
        "size"=>3,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $separadorPar = "separadorPar";
    $phpWord->addParagraphStyle($separadorPar, [
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsHdrLeftText = "recordsHdrLeftText";
    $phpWord->addFontStyle($recordsHdrLeftText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsHdrLeftPar = "recordsHdrLeftPar";
    $phpWord->addParagraphStyle($recordsHdrLeftPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
    ]);
    $recordsHdrText = "recordsHdrText";
    $phpWord->addFontStyle($recordsHdrText, [
        "name"=>"Univers 55",
        "scale"=>60,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsHdrPar = "recordsHdrPar";
    $phpWord->addParagraphStyle($recordsHdrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsDetLeftText = "recordsDetLeftText";
    $phpWord->addFontStyle($recordsDetLeftText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "spacing" => -5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetLeftPar = "recordsDetLeftPar";
    $phpWord->addParagraphStyle($recordsDetLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $recordsDetText = "recordsDetText";
    $phpWord->addFontStyle($recordsDetText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetPar = "recordsDetPar";
    $phpWord->addParagraphStyle($recordsDetPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // numero de carrera y dia de la semana
    $raceNmbrText = "raceNmbrText";
    $phpWord->addFontStyle($raceNmbrText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "scale"=>70,
        "size"=>35,
        "spacing"=>-50,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $raceNmbrRedText = "raceNmbrRedText";
    $phpWord->addFontStyle($raceNmbrRedText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>70,
        "size"=>18,
        "spacing"=>-20,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $raceNmbrPar = "raceNmbrPar";
    $phpWord->addParagraphStyle($raceNmbrPar, [
        "spacing"=>-60,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $dowText = "dowText";
    $phpWord->addFontStyle($dowText, [
        "name"=>"Univers 65 Bold",
        "scale"=>70,
        "size"=>15,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF",
        "bgColor"=>"000000",

    ]);
    $dowPar = "dowPar";
    $phpWord->addParagraphStyle($dowPar, [
        "spacing"=>-50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "shading"=>["fill"=>"000000"],
    ]);
    // condiciones linea uno
    $conditions1Text = "conditions1Text";
    $phpWord->addFontStyle($conditions1Text, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>90,
        "size"=>7,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions1Par = "conditions1Par";
    $phpWord->addParagraphStyle($conditions1Par, [
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
    ]);
    // condiciones linea dos
    $conditions2Text = "conditions2Text";
    $phpWord->addFontStyle($conditions2Text, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>90,
        "spacing"=>-10,
        "size"=>6.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions2Par = "conditions2Par";
    $phpWord->addParagraphStyle($conditions2Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-40,
    ]);
    // premios
    $invertedTitText = "invertedTitText";
    $phpWord->addFontStyle($invertedTitText, [
        "name"=>"Univers 65 Bold",
        "scale"=>80,
        "spacing"=>-10,
        "size"=>9.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $invertedTitPar = "invertedTitPar";
    $phpWord->addParagraphStyle($invertedTitPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-40,
        "shading"=>["fill"=>"000000"],
    ]);
    $pricesText = "pricesText";
    $phpWord->addFontStyle($pricesText, [
        //"name"=>"Univers 55",
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $pricesCondText = "pricesCondText";
    $phpWord->addFontStyle($pricesCondText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>5,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $pricesTitText = "pricesTitText";
    $phpWord->addFontStyle($pricesTitText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $pricesPar = "pricesPar";
    $phpWord->addParagraphStyle($pricesPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>30,
        "spaceAfter"=>10,
        "spacing"=>-40,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*0.14)
        ],
    ]);
    // distancia
    $distanceText = "distanceText";
    $phpWord->addFontStyle($distanceText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "scale"=>75,
        "size"=>9,
        //"spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $distancePar = "distancePar";
    $phpWord->addParagraphStyle($distancePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>0,
    ]);
    // record
    $recordText = "recordText";
    $phpWord->addFontStyle($recordText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>75,
        "size"=>5.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordPar = "recordPar";
    $phpWord->addParagraphStyle($recordPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // DETALLE
    // header
    $headerText = "headerText";
    $phpWord->addFontStyle($headerText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerBoldText = "headerBoldText";
    $phpWord->addFontStyle($headerBoldText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerC2Text = "headerC2Text";
    $phpWord->addFontStyle($headerC2Text, [
        "name"=>"Helvetica",
        "scale"=>90,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerPar = "headerPar";
    $phpWord->addParagraphStyle($headerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerLeftPar = "headerLeftPar";
    $phpWord->addParagraphStyle($headerLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerRightPar = "headerRightPar";
    $phpWord->addParagraphStyle($headerRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // Horse Number
    $horseNumberText = "horseNumberText";
    $phpWord->addFontStyle($horseNumberText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>40,
        "spacing"=>0,
        "size"=>22.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horseNumberPar = "horseNumberPar";
    $phpWord->addParagraphStyle($horseNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Horse Details
    $horsedetailsText = "horsedetailsText";
    $phpWord->addFontStyle($horsedetailsText, [
        "name"=>"Univers 55",
        "scale" => 80,
        "spacing" => -5,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsedetailsPar = "horsedetailsPar";
    $phpWord->addParagraphStyle($horsedetailsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*$C2-80)
        ],
        "spacing" => -60,
    ]);
    // horse name
    $horsenameText = "horsenameText";
    $phpWord->addFontStyle($horsenameText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "scale" => 85,
        "spacing" => 0,
        "size"=>9,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsenameRedText = "horsenameRedText";
    $phpWord->addFontStyle($horsenameRedText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "scale" => 75,
        "spacing" => -9,
        "size"=>9,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsenamePar = "horsenamePar";
    $phpWord->addParagraphStyle($horsenamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>10,
        "spaceAfter"=>10,
        "spacing"=>-50,
    ]);
    // jockey name
    $jockeynameText = "jockeynameText";
    $phpWord->addFontStyle($jockeynameText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale" => 85,
        "spacing" => 0.8,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeynamePar = "jockeynamePar";
    $phpWord->addParagraphStyle($jockeynamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // jockey weight
    $jockeyweightText = "jockeyweightText";
    $phpWord->addFontStyle($jockeyweightText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "size"=>8,
        //"scale"=>80,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeyweightPar = "jockeyweightPar";
    $phpWord->addParagraphStyle($jockeyweightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // implements
    $implementsText = "implementsText";
    $phpWord->addFontStyle($implementsText, [
        "name"=>"Univers 55",
        "scale" => 90,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $implementsPar = "implementsPar";
    $phpWord->addParagraphStyle($implementsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // trainer
    $trainerText = "trainerText";
    $phpWord->addFontStyle($trainerText, [
        "name"=>"Univers 55",
        //"scale" => 80,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $trainerPar = "trainerPar";
    $phpWord->addParagraphStyle($trainerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>10,
        "spaceAfter"=>0,
    ]);
    // position
    $positionText = "positionText";
    $phpWord->addFontStyle($positionText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>7,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $positionPar = "positionPar";
    $phpWord->addParagraphStyle($positionPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // history data
    $historyText = "historyText";
    $phpWord->addFontStyle($historyText, [
        "name"=>"Univers 55",
        "size"=>5.1,
        "scale" => 75,
        "spacing"=>-3,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyBoldText = "historyBoldText";
    $phpWord->addFontStyle($historyBoldText, [
        //"name"=>"Univers 65",
        //"name"=>"Arial Black",
        "name"=>"Univers 65",
        "size"=>4.5,
        "scale" => 75,
        "spacing"=>-3,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    // history data
    $historySplitText = "historySplitText";
    $phpWord->addFontStyle($historySplitText, [
        "name"=>"Univers 55",
        "size"=>5.1,
        "scale" => 75,
        "spacing"=>0,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyTextPar = "historyTextPar";
    $phpWord->addParagraphStyle($historyTextPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>-40,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $cposText = "cposText";
    $phpWord->addFontStyle($cposText, [
        "name"=>"Univers 55",
        "size"=>4,
        //"scale" => 60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyPar = "historyPar";
    $phpWord->addParagraphStyle($historyPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyLeftPar = "historyLeftPar";
    $phpWord->addParagraphStyle($historyLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historySpanLeftPar = "historySpanLeftPar";
    $phpWord->addParagraphStyle($historySpanLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', ($width*$C12+$width*$C13)-60)
        ],
    ]);
    $historyRightPar = "historyRightPar";
    $phpWord->addParagraphStyle($historyRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // additional data
    $addDataText = "addDataText";
    $phpWord->addFontStyle($addDataText, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Black",
        "name"=>"Univers 65 Bold",
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $addDataPar = "addDataPar";
    $phpWord->addParagraphStyle($addDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            //new \PhpOffice\PhpWord\Style\Tab('right', $anchoHistoria*0.75),
            new \PhpOffice\PhpWord\Style\Tab('right', $anchoHistoria-30)
        ],
    ]);
    // footer slogan
    $footSloganDataText = "footSloganDataText";
    $phpWord->addFontStyle($footSloganDataText, [
        "name"=>"Univers 65",
        "size"=>12,
        "scale" => 60,
        "spacing"=>-15,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footPoolDe4Text = "footPoolDe4Text";
    $phpWord->addFontStyle($footPoolDe4Text, [
        //"name"=>"Univers 65 Bold",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65 Bold",
        "size"=>8,
        //"scale" => 60,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footSloganDataPar = "footSloganDataPar";
    $phpWord->addParagraphStyle($footSloganDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    $footFavDataText = "footFavDataText";
    $phpWord->addFontStyle($footFavDataText, [
        "name"=>"Univers 65 Bold",
        "scale" => 90,
        "spacing" => -10,
        "size"=>9,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footFavDataPar = "footFavDataPar";
    $phpWord->addParagraphStyle($footFavDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.05),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.50),
        ],
    ]);
    $footFavNamText = "footFavNamText";
    $phpWord->addFontStyle($footFavNamText, [
        //"name"=>"Univers 65",
        //"name"=>"Arial Black",
        "name"=>"Univers 75 Black",
        "scale" => 80,
        "size"=>8,
        "spacing"=>-10,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footFavNamPar = "footFavNamPar";
    $phpWord->addParagraphStyle($footFavNamPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.1),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.7),
        ],
    ]);

    $top3 = "";
    $actualrace = "";
    $validcnt = 0;
    $ojoavizor = "";
    $ojoavizorant = "";
    $implementch = "";
    $primerfav = "";
    $segundofav = "";
    $tercerfav = "";
    while ($row = $rs->fetch_assoc()){
        $racersfc = array();
        $ojoavizorant = $ojoavizor;
        if (strlen($row["forecastracers"]))
            $racersfc = json_decode($row["forecastracers"]);
        foreach ($racersfc as $racer){
            if ($racer->forecast == 4){
                $sql =  "SELECT     H.dsc, R.number " . 
                        "FROM       horses H " . 
                        "INNER JOIN racers R " .
                        "ON         H.id=R.horseid " . 
                        "WHERE      R.id=" . $racer->id;
                if (!$rs2 = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                if ($row2 = $rs2->fetch_assoc()){
                    $ojoavizor = $row2["dsc"] . " (" . $row2["number"] . ")";
                }
            }
        }

        if ($row["racenumber"] != $actualrace){
            $validcnt++;
            if ($actualrace != ""){
                $foottable = $section->addTable([$defaultTableFullWidthStyle]);
                $foottable->addRow();
                $cell = $foottable->addCell($width*0.05, $sloganInvCellStyle);
                    $cell->addText("Fav.",
                                    $invertedTitText,
                                    $invertedTitPar
                    );
                $cell = $foottable->addCell($width*0.61, $sloganCellStyle);
                    $cell->addText($forecastdsc,
                        $footFavNamText,
                        $footFavNamPar
                    );
                $cell = $foottable->addCell($width*0.15, $sloganInvCellStyle);
                    $cell->addText("Sin Favoritos:",
                                    $invertedTitText,
                                    $invertedTitPar
                    );
                $cell = $foottable->addCell($width*0.19, $sloganCellStyle);
                    $cell->addText($ojoavizorant,
                        $footFavNamText,
                        $footFavNamPar
                    );
            }

            $forecastgaceta = $row["top3GH"];
            $actualrace = $row["racenumber"];

            ///////////////////////////////
            // calcular cambio de implementos
            $implementch = "";
            $sql =  "SELECT     H.id horseid, H.dsc horsename, R.implementstypeI implements " . 
                    "FROM       racers R " .
                    "INNER JOIN horses H " . 
                    "ON         R.horseid=H.id " .  
                    "WHERE      R.raceid=" . $row["raceid"] . " " . 
                    "ORDER BY   R.position";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $impcnt = 0;
            while ($row2 = $rs2->fetch_assoc()){
                $sql =  "SELECT     raceid " .
                        "FROM       wrk_horsehistory " .
                        "WHERE      horseid = " . $row2["horseid"] . " " .
                        "AND        raceid <> " . $row["raceid"] . " " .
                        "AND        date < '"   . $row["reuniondate"] . "' " .
                        "AND        arrivalposition <> 0 " .
                        "ORDER BY   date desc " .
                        "LIMIT 1 ";
                if (!$rs3 = $db->query($sql))
                    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                $lastraceid = "";
                if ($row3 = $rs3->fetch_assoc())
                    $lastraceid = $row3["raceid"];
                if ($lastraceid != ""){
                    $sql = "SELECT      R.implementstypeI implements " . 
                            "FROM       races RA " . 
                            "INNER JOIN racers R " . 
                            "ON         RA.id = R.raceid " . 
                            "WHERE      horseid=" . $row2["horseid"] . " " . 
                            "AND        RA.id=" . $lastraceid;
                    if (!$rs3 = $db->query($sql))
                        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                    if (!$row3 = $rs3->fetch_assoc())
                        badEnd("500", array("sql"=>$sql, "msg"=>"Ocurrio un error"));
                    $implements = json_decode($row2["implements"]);
                    $lastimplements = json_decode($row3["implements"]);
                    // calcular diferencias
                    $restar = "";
                    foreach($lastimplements as $limp){
                        $found=false;
                        foreach($implements as $imp)
                            if ($limp->abbr == $imp->abbr)
                                $found = true;
                        if (!$found)
                            $restar .= "." . $limp->abbr;
                    }
                    $sumar = "";
                    foreach($implements as $imp){
                        $found=false;
                        foreach($lastimplements as $limp)
                            if ($limp->abbr == $imp->abbr)
                                $found = true;
                        if (!$found)
                            $sumar .= "." . $imp->abbr;
                    }
                    if ($restar != "")
                        $restar = "Quit" . $restar;
                    if ($sumar != "")
                        $sumar = "Pus" . $sumar;
    
                    if ($sumar . $restar != ""){
                        $implementch .= $row2["horsename"] . ": " . $sumar . $blank . $blank . $restar . "<w:br/>";
                        $impcnt++;
                    }
                }
            }
            // quitar ultimo enter
            if (strlen($implementch) > 0)
                $implementch = substr($implementch, 0, -7);
            // agregar lineas en blanco
            //for ($i=0; $i<4-$impcnt; $i++)
            //    $implementch .=  "<w:br/>";
            // fin cambio de implementos
            ///////////////////////////

            // calcular los 5 mejores segun speedrating
            $sql =  "SELECT 	GROUP_CONCAT(`number` SEPARATOR '-') top5 " . 
                    "FROM 	    (SELECT number FROM racers WHERE raceid=" . $row["raceid"] . " ORDER BY speedr LIMIT 5) A";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $srtop5="";
            if ($row2 = $rs2->fetch_assoc()){
                $srtop5 = $row2["top5"]; 
            }

            $section = $phpWord->addSection([
                "marginTop"=>$top,
                "marginBottom"=>$bottom,
                "marginLeft"=>$left+30,
                "marginRight"=>$right+30,
                "pageSizeH"=>$height,
                "pageSizeW"=>$width,
            ]);

            $primerfav = "";
            $segundofav = "";
            $tercerfav = "";
            $forecastdsc = "";
            //$forecastgaceta = "";
            $lastfc = 0;

            // PREMIO ESPECIAL
            if ($row["extraprice"] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("Premiación Especial Adicional: " . $row["extrapricecurr"] . " " . number_format($row["extraprice"], 0, ",", "."),
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            // Loto Hípico
            if ($lotohip[$actualrace] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);
                $cell->addText("AQUÍ COMIENZA EL LOTO HÍPICO",
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            // Triple Apuesta
            if ($tripleap[$actualrace] != 0){
                $bettab = $cell->addTable([$defaultTableFullWidthStyle]);
                $bettab->addRow();
                $betcell = $bettab->addCell($width);
                $raceord = $row["raceord"]*1;
                //$betcell->addText("TRIPLE APUESTA " . $validcnt . " - " . $validcnt+1 . " - " . $validcnt+2, $initialBannerText, $initialBannerPar);
                $betcell->addText("TRIPLE APUESTA " . $raceord . " - " . $raceord+1 . " - " . $raceord+2, $bets2smlText, $betssml2Par);
            }
            // Clasico
            if ($row["racetypeid"] != -1){
                $maintable = $section->addTable([$defaultTableFullWidthBorderStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width, $defaultBorderCellStyle);
                $cell->addText($row["racetypedsc"],
                                $classicText,
                                $classicPar
                );
            }

            // tabla del encabezado XXX
            $maintable = $section->addTable([$defaultTableFullWidthBorderStyle]);
            $maintable->addRow();
            // columna izquierda
            $cell = $maintable->addCell($width*0.20, $defaultBorderCellStyle);
            $cell->addText("\tN.\t" . $row["racenumber"] . $blank,
                    $dateText, $datePar);
            $cell->addText("\t" . $row["hora"],
                    $timeText, $timePar);
            $textRun = $cell->addTextRun($raceNmbrPar);
            $textRun->addText($validcnt . "a", $raceNmbrText, $raceNmbrPar);
            $textRun->addText(" Válida", $raceNmbrRedText, $raceNmbrPar);
            $cell->addText($row["raceord"] . "a " . $dow[$row["dow"]-1], $dowText, $dowPar);

            // columna dentro izquierda
            $cell = $maintable->addCell($width*0.35, $defaultBorderCellStyle);
            $cell->addText(mb_strtoupper($row["condicion2"]),
                            $conditions1Text, $conditions1Par);
            $cell->addText((str_replace($row["condicion2"], "", $row["conditiondsc"])), 
                            $conditions2Text, $conditions2Par);
            // incluir una linea si la condicion es corta
            //if (strlen((str_replace($row["condicion2"], "", $row["conditiondsc"])))<90)
                $cell->addText("<w:br/>", 
                                $conditions2Text, $conditions2Par);
            $cell->addText( "DISTANCIA: " . $blank . $row["distancia"] . $blank . " METROS"
                    , $distanceText, $distancePar);
            $cell->addText( mb_strtoupper($row["recordhorse"]) . " - " .
                            $row["recordjockey"] . " - Ks." . $row["recordweight"] . " - " .
                            number_format($row["recordtime"], 1, ".") . " - " . $row["recorddate"]
                    , $recordText, $recordPar);
        

            // columna dentro derecha
            $cell = $maintable->addCell($width*0.07, $defaultBorderCellStyle);
            
            $cell->addText("PREMIOS"
                            , $invertedTitText, $invertedTitPar);
            $cell->addText($row["pricecurr"] . ".\t" . number_format($row["mainprice"],2, ",", ".")
                            , $pricesTitText, $pricesPar);
            if ($racecourseid == 2 && $row["additionalprice"]*1 <> 0){
                if ($row["pricesformat"]=="0"){
                    $cell->addText( "1º\t" . number_format($row["firstplace"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                    $cell->addText( "2º\t" . number_format($row["secondplace"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                    $cell->addText( "3º\t" . number_format($row["thirdplace"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                    $cell->addText( "4º\t" . number_format($row["fourthplace"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                    $cell->addText( "5º\t" . number_format($row["fifthplace"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                    $textRun = $cell->addTextRun($pricesPar);
                    $textRun->addText( "Prima Criador"
                            , $pricesCondText, $pricesPar);
                    $textRun->addText( "\t" . number_format($row["additionalprice"], 0, ",", ".") . "%"
                            , $pricesText, $pricesPar);
                }else{
                    $cell->addText( "1º\t" . number_format($row["mainprice"]*$row["firstplace"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                    $cell->addText( "2º\t" . number_format($row["mainprice"]*$row["secondplace"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                    $cell->addText( "3º\t" . number_format($row["mainprice"]*$row["thirdplace"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                    $cell->addText( "4º\t" . number_format($row["mainprice"]*$row["fourthplace"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                    $cell->addText( "5º\t" . number_format($row["mainprice"]*$row["fifthplace"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                    $textRun = $cell->addTextRun($pricesPar);
                    $textRun->addText( "Prima Criador"
                            , $pricesCondText, $pricesPar);
                    $textRun->addText( "\t" . number_format($row["mainprice"]*$row["additionalprice"]/100, 2, ",", ".")
                            , $pricesText, $pricesPar);
                }
            }else{
                $cell->addText( "1º\t" . number_format($row["mainprice"]*$row["firstplace"]/100, 2, ",", ".")
                        , $pricesText, $pricesPar);
                $cell->addText( "2º\t" . number_format($row["mainprice"]*$row["secondplace"]/100, 2, ",", ".")
                        , $pricesText, $pricesPar);
                $cell->addText( "3º\t" . number_format($row["mainprice"]*$row["thirdplace"]/100, 2, ",", ".")
                        , $pricesText, $pricesPar);
                $cell->addText( "4º\t" . number_format($row["mainprice"]*$row["fourthplace"]/100, 2, ",", ".")
                        , $pricesText, $pricesPar);
                $cell->addText( "5º\t" . number_format($row["mainprice"]*$row["fifthplace"]/100, 2, ",", ".")
                        , $pricesText, $pricesPar);
            }

            // columna derecha
            $lincnt = 0;
            $cell = $maintable->addCell($width*0.38, $defaultBorderCellStyle);
            if ($pool4[$actualrace] != "0"){
                $lincnt++;
                $cell->addText($pool4[$actualrace] . "ª Pool de 4",
                                $footPoolDe4Text,
                                $footSloganDataPar
                );
            }
            if ($superfecta[$actualrace] != "0"){
                $lincnt++;
                $cell->addText("SUPERFECTA",
                                $footPoolDe4Text,
                                $footSloganDataPar
                );
            }
            if ($dobperfecta[$actualrace] != "0"){
                $lincnt++;
                $cell->addText($dobperfecta[$actualrace] . "ª DOBLE PERFECTA",
                                $footPoolDe4Text,
                                $footSloganDataPar
                );
            }
            // espacios en blanco para rellenar falta de jugadas
            for ($i=0; $i<3-$lincnt; $i++){
                $cell->addText($blank,
                                $footPoolDe4Text,
                                $footSloganDataPar);
            }
            $cell->addText("CAMBIO DE IMPLEMENTOS", $impchBoldText, $impchPar);
            if ($impcnt>0){
                if ($impcnt>6) // reducir espaciado mucho
                    $cell->addText($implementch, $impchred2Text, $impchred2Par);
                else
                    if ($impcnt>4) // reducir espaciado
                        $cell->addText($implementch, $impchredText, $impchredPar);
                    else
                        $cell->addText($implementch, $impchText, $impchPar);
            }else{
                $cell->addText("NO HUBO", $impchText, $impchPar);
            }

            // Agregar separador
            $maintable = $section->addTable([$defaultTableFullWidthStyle]);
            $maintable->addRow();
            $cell = $maintable->addCell($width);
            $cell->addText($blank, $separadorText, $separadorPar);

            // ENCABEZADO DEL DETALLE
            $detailtable = $section->addTable([$defaultTableFullWidthStyle]);
                $detailtable->addRow();
                $cell = $detailtable->addCell($width*$C1, $headerCellFullBrdStyle);
                $cell->addText( "N°", $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C2, $headerCellFullBrdStyle);
                $cell->addText( "Propietario, Divisa, Ejemplar, Sexo, Pelaje,<w:br/>Edad, Padres y Origen"
                        , $headerC2Text, $headerPar);

                $cell = $detailtable->addCell($width*$C3, $headerCellFullBrdStyle);
                $cell->addText( "Jinete, Ks, Imple-<w:br/>mentos, Prep."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C4, $headerCellFullBrdStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                //$cell = $detailtable->addCell($width*$C16, $headerCellTopDwnBrdStyle);
                ////$cell->addText( "Ind<w:br/>Vel."
                //$cell->addText( "Ind"
                //        , $headerText, $headerPar);
                //$cell->addText( "Vel."
                //        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C5, $headerCellTopDwnBrdStyle);
                $cell->addText( "Fecha"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C6, $headerCellTopDwnBrdStyle);
                $cell->addText( "Carr."
                        , $headerText, $headerRightPar);
                $cell->addText( "ant."
                        , $headerText, $headerRightPar);

                $cell = $detailtable->addCell($width*$C7, $headerCellTopDwnBrdStyle);
                $cell->addText( "Peso<w:br/>Ejem"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C8, $headerCellTopDwnBrdStyle);
                $cell->addText( "Dtcia"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C9, $headerCellTopDwnBrdStyle);
                $cell->addText( "PP."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C10, $headerCellTopDwnBrdStyle);
                $cell->addText( "1000<w:br/>300m"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C11, $headerCellTopDwnBrdStyle);
                $cell->addText( "Lleg"
                        , $headerBoldText, $headerPar);

                $cell = $detailtable->addCell($width*$C12, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ks Jinete                      Divid"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C13, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ganador"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C14, $headerCellTopDwnBrdStyle);
                $cell->addText( "Cpos"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C15, $headerCellTopDwnBrdStyle);
                $cell->addText( "Serie"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C17, $headerCellTopDwnBrdStyle);
                $cell->addText( "Tmpo Gndor"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C18, $headerCellRightBrdStyle);
                $cell->addText( "Tmpo Ejem"
                        , $headerText, $headerPar);

//                $cell = $detailtable->addCell($width*$C19, $headerCellStyle);
//                $cell->addText( "# Ejs"
//                        , $headerText, $headerPar);

            $top3 = $row["top3"];
        }
        // RENGLONES

        // Calcular actuaciones

        // Verificar información de pronósticos
        
        $racersfc = array();
        if (strlen($row["forecastracers"]))
            $racersfc = json_decode($row["forecastracers"]);

        $proncmt = getHorseForecasts($row["racerid"], $racersfc);

        switch ($proncmt->forecast){
            case 1:
                $primerfav = $row["horsename"] . " (" . $row["horsenumber"] .  ")";
                break;
            case 2:
                $segundofav = $row["horsename"] . " (" . $row["horsenumber"] .  ")";
                break;
            case 3:
                $tercerfav = $row["horsename"] . " (" . $row["horsenumber"] .  ")";
                break;
        }
        $forecastdsc = $primerfav . " - " . $segundofav . " - " . $tercerfav;

        $detailtable->addRow();
        $cell = $detailtable->addCell($width*$C1, $detailCellStyleFullBrd);
            $cell->addText( $row["horsenumber"]
                    , $horseNumberText, $horseNumberPar);

        $cell = $detailtable->addCell($width*$C2, $detailCellStyleFullBrd);
            $cell->addText( "Stud \"" . clnprn($row["studname"]) . "\" - " . clnprn($row["studabbr"])
                    , $horsedetailsText, $horsedetailsPar);
            $horseText = $horsenameText;
            if (strlen($row["horsename"])>15)
                $horseText = $horsenameRedText;
            $cell->addText( $row["horsename"], $horseText, $horsenamePar);
            $cell->addText( $row["gender"] . ".". $row["furabbr"] . "." . $row["age"] . "a. " . $row["horsefather"] . " - " . $row["horsemother"]
                    , $horsedetailsText, $horsedetailsPar);

        $cell = $detailtable->addCell($width*$C3, $detailCellStyleFullBrd);
            $cell->addText( str_replace(" ", "", $row["jockeyname"])
                    , $jockeynameText, $jockeynamePar);
            $cell->addText( $row["jockeyweight"]
                , $jockeyweightText, $jockeyweightPar);
            // medicamentos
            $medicaments = [];
            if (strlen($row["medicaments"]))
                $medicaments = json_decode($row["medicaments"]);
            $meds = "";
            foreach($medicaments as $medicament)
                $meds .= $medicament->abbr . ".";
            if ($meds == "") $meds = "--";
            // implementos
            $implements = [];
            if (strlen($row["implements"]))
                $implements = json_decode($row["implements"]);
            $imps = "";
            foreach($implements as $implement)
                $imps .= $implement->abbr . ".";
            if ($imps == "") $imps = "--";
            $cell->addText( $imps
                , $implementsText, $implementsPar);
            $cell->addText( str_replace(" ", "", $row["trainername"])
                , $trainerText, $trainerPar);

        $cell = $detailtable->addCell($width*$C4, $detailCellStyleFullBrd);
            $cell->addText( $row["horseposition"]
                , $positionText, $positionPar);

        $cell = $detailtable->addCell($anchoHistoria, $detailCellSpanStyleFullBrd); 

            $htsareatable = $cell->addTable([$defaultTableHstWidthStyle]);
            // historia
            $hsttable = $cell->addTable([$defaultTableHstWidthStyle]);
            $sql3 = "SELECT     * " .
                    "FROM " .
                    "(" .
                    "SELECT     * " .
                    "FROM       wrk_horsehistory " .
                    "WHERE      horseid = " . $row["horseid"] . " " .
                    "AND        raceid <> " . $row["raceid"] . " " .
                    "AND        date < '"   . $row["reuniondate"] . "' " .
                    "ORDER BY   date desc " .
                    "LIMIT 4 " .
                    ") A " .
                    "ORDER BY   date ";
            if (!$rs3 = $db->query($sql3))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $lastrun = "";
            for  ($i=0; $i<4; $i++){
                // no tiene carreras
                if (mysqli_num_rows($rs3) == 0){
                    $hsttable->addRow(-100*4);
                    $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                        $cell->addText(clnprn($row["horseobs"]), $historyText, $historyTextPar);
                    $i += 1;
                    $i = 4;
                } else
                // lineas en blanco antes
                if ($i < 4 - mysqli_num_rows($rs3)){
                    $hsttable->addRow(-100);
                    $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                        $cell->addText($blank, $historyText, $historyLeftPar);
                    //$i += 1;
                }else{
                    if ($row3 = $rs3->fetch_assoc()){
                        $hsttable->addRow(-100);
                        //$cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                        //    $cell->addText(number_format($row3["srating"],0,",","."), $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                            $cell->addText(date_format(date_create($row3["date"]), 'd-m'), $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                            $cell->addText($row3["racecourseabbr"].$row3["racenumber"], $historyText, $historyRightPar);
                            //$cell->addText($row3["racecourseabbr"].$row3["racenumber"], $historyText, $historyPar);
                        if ($row3["retdsc"]==""){
                            $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                                $cell->addText($row3["weight"], $historyText, $historyPar);
                            $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                                $cell->addText($row3["distancename"], $historyText, $historyPar);
                            $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                                $cell->addText($row3["position"], $historyText, $historyPar);
                            $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                                $cell->addText($row3["pos800"].$blank.$blank.$blank.$blank.$row3["pos400"], $historyText, $historyPar);
                            $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                                $cell->addText($row3["arrivalposition"], $historyBoldText, $historyPar);
                            $cell = $hsttable->addCell($width*$C12+$width*$C13, $detailSpan2CellStyle);
                                if ($row3["arrivalposition"] == "1")
                                    $cell->addText($row3["jockeyweight"]." ".$row3["jockeyabbr"].",".number_format($row3["dividends"],2,",","") . "\t2°".norm($row3["seconddsc"]), $historyText, $historySpanLeftPar);
                                else
                                    $cell->addText($row3["jockeyweight"]." ".$row3["jockeyabbr"].",".number_format($row3["dividends"],2,",","") . "\t".norm($row3["winnerdsc"]), $historyText, $historySpanLeftPar);
                            //$cell = $hsttable->addCell($width*$C12, $detailCellStyle);
                            //    $cell->addText($row3["jockeyweight"].$blank.$blank.str_replace(". ", ".", $row3["jockeyabbr"]).",".$row3["dividends"], $historySplitText, $historyLeftPar);
                            //$cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                            //    $cell->addText(norm($row3["winnerdsc"]), $historyText, $historyRightPar);
                            $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                                $cell->addText($row3["bodiesabbr"] == '' ? $blank : convFracciones($row3["bodiesabbr"]), $cposText, $historyRightPar);
                            $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                                $cell->addText(substr($row3["serie"], 0, 6), $historyText, $historyPar);
                            $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                                $cell->addText(number_format($row3["winnertime"],1,",","."), $historyText, $historyRightPar);
                            $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                                if ($row3["arrivalposition"] == "1")
                                    $cell->addText("Ganó", $historyText, $historyRightPar);
                                else
                                    if ($row3["stumbledsc"] != "")
                                        $cell->addText($row3["stumbledsc"], $historyText, $historyRightPar);
                                    else
                                        $cell->addText(number_format($row3["finishtime"],1,",","."), $historyText, $historyRightPar);
                        }else{
                            $cell = $hsttable->addCell($width*$C7, $detailSpan12CellStyle);
                                $retword = $row["gender"]=="Y" ? "Retirada" : "Retirado";
                                $cell->addText($retword . " por " . $row3["retdsc"], $historyText, $historyLeftPar);
                        }
                        $lastrun = $row3["date"];
                    }
                }
            }

            //******************
            $sincorrer = "";

            if ($lastrun != "" && intval((strtotime($reuniondate) - strtotime($lastrun)) / (60 * 60 * 24)) >= 35){
                $sincorrer = intval((strtotime($reuniondate) - strtotime($lastrun)) / (60 * 60 * 24)) . "sc";
            }

            $sql4 = "SELECT     SUM(IF(R.arrivalposition>0 OR R.stumbleid IS NOT NULL, 1, 0)) cnt, " . 
                    "           SUM(IF(R.arrivalposition=1, 1, 0)) cntwin, " . 
                    "           MAX(IF(R.arrivalposition=1, RE.date, '1900-01-01')) datwin, " . 
                    "           SUM(IF(R.arrivalposition>0 AND YEAR(RE.date)=YEAR('" . $date . "'), 1, 0)) cntyr, " . 
                    "           SUM(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), 1, 0)) cntyrwin, " . 
                    "           MAX(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), RE.date, '1900-01-01')) datyrwin, " . 
                    "           SUM(IF(R.arrivalposition=1 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.firstplace,0) / 100, 0)) prc1, " . 
                    "           SUM(IF(R.arrivalposition=2 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.secondplace,0) / 100, 0)) prc2, " . 
                    "           SUM(IF(R.arrivalposition=3 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.thirdplace,0) / 100, 0)) prc3, " . 
                    "           SUM(IF(R.arrivalposition=4 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.fourthplace,0) / 100, 0)) prc4, " . 
                    "           SUM(IF(R.arrivalposition=5 AND YEAR(RE.date)=YEAR('" . $date . "'), IFNULL(RA.mainprice,0) * IFNULL(RA.fifthplace,0) / 100, 0)) prc5, " . 
                    "           SUM( " . 
                    "               CASE R.arrivalposition " . 
                    "                   WHEN 1 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.firstplace,0) / 100 " . 
                    "                   WHEN 2 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.secondplace,0) / 100 " . 
                    "                   WHEN 3 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.thirdplace,0) / 100 " . 
                    "                   WHEN 4 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.fourthplace,0) / 100 " . 
                    "                   WHEN 5 THEN IFNULL(RA.mainprice,0) * IFNULL(RA.fifthplace,0) / 100 " . 
                    "                   ELSE 0 " . 
                    "               END) pricebsX " . 
                    "FROM       racers R " . 
                    "INNER JOIN races RA " . 
                    "ON         R.raceid=RA.id " . 
                    "INNER JOIN reunions RE " . 
                    "ON         RA.reunionid=RE.id " .
                    "WHERE      R.horseid=" . $row["horseid"] . " " . 
                    "AND        RE.date<'" . $date . "'"; 

            if (!$rs4 = $db->query($sql4))
                badEnd("500", array("sql"=>$sql4, "msg"=>$db->error));
            if (!$row4 = $rs4->fetch_assoc())
                badEnd("500", array("sql"=>$sql4, "msg"=>"ERROR RARO"));

            // calcular días sin ganar general
            if (!isset($row4["datwin"]) || $row4["datwin"] == "1900-01-01"){
                $sg = $row4["cnt"];
            }else{
                // calcular actuaciones sin ganar
                $sql3 = "SELECT     COUNT(*) cnt " .
                        "FROM       racers R  " .
                        "INNER JOIN races RA  " .
                        "ON	        R.raceid=RA.id " .
                        "INNER JOIN reunions RE  " .
                        "ON	        RA.reunionid=RE.id " .
                        "WHERE 	    R.horseid=" . $row["horseid"] . " " . 
                        //"AND        R.arrivalposition > 1 " .
                        "AND        RE.date > '" . $row4["datwin"] . "' " .
                        "AND        RE.date < '" . $date . "'";
                if (!$rs3 = $db->query($sql3))
                    badEnd("500", array("log"=>4,"sql"=>$sql3, "msg"=>$db->error));
                if (!$row3 = $rs3->fetch_assoc())
                    badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                $sg = $row3["cnt"];
            }
            // calcular días sin ganar este año
            if (!isset($row4["datyrwin"]) || $row4["datyrwin"] == "1900-01-01"){
                $sgyr = $row4["cntyr"];
            }else{
                // calcular actuaciones sin ganar
                $sql3 = "SELECT     COUNT(*) cnt " .
                        "FROM       racers R  " .
                        "INNER JOIN races RA  " .
                        "ON	        R.raceid=RA.id " .
                        "INNER JOIN reunions RE  " .
                        "ON	        RA.reunionid=RE.id " .
                        "WHERE 	    R.horseid=" . $row["horseid"] . " " . 
                        "AND        R.arrivalposition > 1 " .
                        "AND        RE.date > '" . $row4["datyrwin"] . "' " .
                        "AND        RE.date < '" . $date . "'";
                if (!$rs3 = $db->query($sql3))
                    badEnd("500", array("log"=>2,"sql"=>$sql3, "msg"=>$db->error));
                if (!$row3 = $rs3->fetch_assoc())
                    badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                $sgyr = $row3["cnt"];
            }

            $pricebs = $row4["prc1"] + $row4["prc2"] + $row4["prc3"] + $row4["prc4"] + $row4["prc5"];
            $pricebs = floatval($row4["pricebsX"]);
            $bsstr = "";
            if ($pricebs != 0)
                $bsstr = " " . $row["pricecurr"] . ". " . number_format($pricebs,2,",",".");
            //******************

            // addional info
            $hsttable->addRow();
            $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
            // Poner en mayúsculas comentario de favoritos
            //if ($proncmt->forecast == 4)
            //    $comment = "Ojo avizor";
            //else
                $comment = $proncmt->comment;
            if (in_array(trim(mb_strtolower($proncmt->comment)), ["primer favorito",  "primera favorita",
                                             "segundo favorito", "segunda favorita",
                                             "tercer favorito",  "tercera favorita"]))
                $comment = mb_strtoupper($comment);
            if (mysqli_num_rows($rs3) != 0)
                if ($row4["cnt"] + $row4["cntwin"] + $row4["cntyr"] + $row4["cntyrwin"] != 0)
                    $cell->addText( "De " . $row4["cnt"] . "-" . $row4["cntwin"] . "(" . $sg . ") "
                                        . $comment . ". (" . $meds . ")"
                                        . $blank. $blank . $sincorrer. "\t" . clnprn($row["harasname"]) . $blank . $bsstr . $blank
                                        , $addDataText, $addDataPar);
                else
                    $cell->addText( $comment . ". (" . $meds . ")"
                                        . "  " . $sincorrer. "\t" . clnprn($row["harasname"]) . $blank . $bsstr. $blank
                                        , $addDataText, $addDataPar);
            else
                $cell->addText( $comment . " (" . $meds . ")"
                                . "\t" . $sincorrer . clnprn($row["harasname"])
                            , $addDataText, $addDataPar);

    }
    if ($actualrace != ""){
        $foottable = $section->addTable([$defaultTableFullWidthBorderStyle]);
        $foottable->addRow();
        $cell = $foottable->addCell($width*0.05, $sloganInvCellStyle);
            $cell->addText("Fav.",
                            $invertedTitText,
                            $invertedTitPar
            );
        $cell = $foottable->addCell($width*0.61, $sloganCellStyle);
            $cell->addText($forecastdsc,
                $footFavNamText,
                $footFavNamPar
            );
        $cell = $foottable->addCell($width*0.15, $sloganInvCellStyle);
            $cell->addText("Sin Favoritos:",
                            $invertedTitText,
                            $invertedTitPar
            );
        $cell = $foottable->addCell($width*0.19, $sloganCellStyle);
            $cell->addText($ojoavizorant,
                $footFavNamText,
                $footFavNamPar
            );
    }


    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);

    function convFracciones($dsc){
        $blank = chr(194) . chr(160);
        $out = str_replace("1/4", "¼", $dsc);
        $out = str_replace("1/2", "½", $out);
        $out = str_replace("3/4", "¾", $out);
        if (strpbrk($out, "½¼¾") === FALSE)
            $out = $out . $blank . $blank . $blank . $blank;
        return($out);
    }

    function norm($dsc){
        $out = ucwords(mb_strtolower($dsc, 'UTF-8'));
        $out = str_replace(" De ", " de ", $out);
        $out = str_replace(" La ", " la ", $out);
        $out = str_replace(" El ", " el ", $out);
        $out = str_replace(" En ", " en ", $out);
        return($out);
    }
    function getHorseForecasts($racerid, $json){
        $salida = json_decode(json_encode(["id"=>0, "number"=>0, "arrivalposition"=>0, "forecast"=>0, "comment"=>"--"]));

        foreach($json as $pron){
            if ($pron->id == $racerid){
                $salida = $pron;
            }
        }
        return($salida);
    }
    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>