<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\Settings;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr, DAYOFWEEK(R.date) dow " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $dow = ["D", "L", "M", "X", "J", "V", "S"];
    $dayletter = $dow[$row["dow"]-1];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr . "IA" . $row["num"] . "." . $outputformat;

    $sql =  "SELECT 	H.dsc dsc, RA.ord, DAYOFWEEK(RE.date) dow " .
            "FROM 		racers R  " .
            "INNER JOIN	races RA  " .
            "ON			R.raceid=RA.id  " .
            "INNER JOIN reunions RE  " .
            "ON			RA.reunionid=RE.id " .
            "INNER JOIN	horses H  " .
            "ON			R.horseid=H.id " .
            "WHERE      RE.id = " . $reunionid . " " .
            "ORDER BY	H.dsc "; 
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $width = 5.32*$pulgada;
    $height = 2.56*$pulgada; //2.56*$pulgada;  // 1440 twip = 1 pulgada
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;

    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";


    // Título
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        "breakType"=>"continuous"
    ]);
    $section->addText("CORREN ESTA SEMANA - " . mb_strtoupper("$racecourse"),
                    [
                        "name"=>"Arial Black",
                        "size"=>16,
                        "bold"=>false,
                        "color"=>"#FFFFFF"
                    ],
                    [
                        "spacing"=>1,
                        "spaceAfter"=>0,
                        'alignment' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
                        "shading"=>["fill"=>$cyan]
                    ]
    );

    // Indice
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        "breakType"=>"nextPage",
        "colsNum"=>6,
        "colsSpace"=>$columnspaces,
        "gutter"=>0
    ]);
    $lastletter = "";
    while ($row = $rs->fetch_assoc()){
        if ($lastletter != substr($row["dsc"],0, 1)){
            $lastletter = substr($row["dsc"],0, 1);
            $section->addText($lastletter, [
                "name"=>"Univers 75 Black",
                "size"=>9,
                "scale" => 120,
                "bold"=>false,
                "color"=>"#000000"
            ],
            [
                'alignment' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
                "spacing"=>1,
                "spaceBefore"=>50,
                "spaceAfter"=>0,
                "keepNext"=>true 
            ]
            );
        }
        $section->addText($row["dsc"] . "\t" . $row["ord"] . "-" . $dayletter, [
                "name"=>"Helvetica",
                "scale" => 90,
                "spacing"=>-5,
                "size"=>5.5,
                "allCaps"=>true,
                "bold"=>false,
                "color"=>"#000000"
            ],
            [
                "spacing"=>1,
                "spaceAfter"=>0,
                "indent"=>0.1,
                "tabs" => [
                            new \PhpOffice\PhpWord\Style\Tab('right', $width/6-($columnspaces/2)-20)
                ]
            ]
        );
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>