<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
//error_reporting(E_ALL);
//ini_set('display_errors', 1);

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    //if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
    //    $racefilter = " AND RA.id BETWEEN " . $_REQUEST["raceidfrom"] . " AND " . $_REQUEST["raceidto"] . " ";
    //}
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr, DAYOFWEEK(R.date) dow " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $dow = ["D", "L", "M", "X", "J", "V", "S"];
    $dayletter = $dow[$row["dow"]-1];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];
    $date = $row["date"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid>0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr . "RC" . $row["num"] . "." . $outputformat;

    $sql =  "SELECT		RA.id raceid, RA.number racenumber, RA.valid, H.dsc horsename, R.number horsenumber, R.horseid " .
            "FROM		racers R " .
            "INNER JOIN horses H " . 
            "ON         R.horseid=H.id " . 
            "INNER JOIN	races RA " .
            "ON			R.raceid=RA.id " .
            "WHERE 		RA.reunionid=" . $reunionid . " " . 
            "AND 		RA.valid BETWEEN 1 AND 6 " .
            $racefilter .
            "ORDER BY	RA.valid, R.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $ordinal = ["Primera", "Segunda", "Tercera", "Cuarta", "Quinta", "Sexta"];

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $height = 8.07*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $firstcolwidth = 0.25*$pulgada;
    $widthcarrera = ($width - $firstcolwidth)/5; // se le resta el ancho de la primera columna
    $blank = chr(194) . chr(160);

    // colores
    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";

    // ESTILOS
    // Celdas
    $headerCellStyle = [
        //"gridSpan" => 2,
        "bgColor"=>$cyan,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $detailCellStyle = [
        //"gridSpan" => 2,
        //"bgColor"=>$bgGray,
        "valign" => "center",
        "borderBottomSize" => 4,
        "borderTopSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $detailHiddenCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderBottomSize" => 4,
        "borderTopSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];        
    $detailFirstCellStyle = [
        //"gridSpan" => 2,
        //"bgColor"=>$bgGray,
        "valign" => "center",
        "borderSize" => 4,
    ];
    // Tablas
    $headerTableStyle = "headerTableStyle";
    $phpWord->addTableStyle($headerTableStyle,[
            "width" => $width,
            "borderColor" => "000000",
            "borderSize" => 4,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 20,
            "cellSpacing" => 0,
        ],$headerCellStyle,$headerCellStyle);
    $detailTableStyle = "detailTableStyle";
    $phpWord->addTableStyle($detailTableStyle,[
            "width" => $width,
            "borderColor" => "000000",
            "borderSize" => 4,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $detailCellStyle, $detailCellStyle);
    // Textos
    $mainHeaderText = "mainHeaderText";
    $phpWord->addFontStyle($mainHeaderText, [
        //"name"=>"Univers 75 Black",
        //"name"=>"Arial Black",
        //"name"=>"Univers 75 Black",
        "name"=>"Futura-Bold",
        "size"=>22,
        "scale" => 100,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $mainHeaderPar = "mainHeaderPar";
    $phpWord->addParagraphStyle($mainHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailFirstColText = "detailFirstColText";
    $phpWord->addFontStyle($detailFirstColText, [
        //"name"=>"Helvetica",
        "name"=>"Futura",
        "size"=>14,
        "scale" => 80,
        "spacing"=>1,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailFirstColPar = "detailFirstColPar";
    $phpWord->addParagraphStyle($detailFirstColPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailHiddenText = "detailHiddenText";
    $phpWord->addFontStyle($detailHiddenText, [
        "name"=>"Arial",
        "size"=>1,
        "spacing"=>-5,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $detailHiddenPar = "detailHiddenPar";
    $phpWord->addParagraphStyle($detailHiddenPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>-5,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailBoldColText = "detailBoldColText";
    $phpWord->addFontStyle($detailBoldColText, [
        //"name"=>"Univers 65",
        //"name"=>"Helvetica Rounded",
        //"name"=>"Arial Black",
        "name"=>"Univers 75 Black",
        "size"=>5.5,
        "scale" => 95,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailBoldRetColText = "detailBoldRetColText";
    $phpWord->addFontStyle($detailBoldRetColText, [
        //"name"=>"Univers 65",
        //"name"=>"Helvetica Rounded",
        //"name"=>"Arial Black",
        "name"=>"Univers 75 Black",
        "size"=>5.5,
        "scale" => 100,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailColText = "detailColText";
    $phpWord->addFontStyle($detailColText, [
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "size"=>5.5,
        "scale" => 90,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailColLastText = "detailColLastText";
    $phpWord->addFontStyle($detailColLastText, [
        //"name"=>"Arial",
        "name"=>"Univers 55",
        "size"=>5.5,
        "scale" => 90,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailColWinnerText = "detailColWinnerText";
    $phpWord->addFontStyle($detailColWinnerText, [
        //"name"=>"Helvetica Rounded",
        //"name"=>"Univers 65",
        //"name"=>"Arial Black",
        "name"=>"Univers 75 Black",
        "size"=>5.5,
        "scale" => 90,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailColPar = "detailColPar";
    $phpWord->addParagraphStyle($detailColPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>-40,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
        ]
    ]);
    $detailColFirstPar = "detailColFirstPar";
    $phpWord->addParagraphStyle($detailColFirstPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>-30,
        "spaceBefore"=>50,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/4),
            new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/2),
            new \PhpOffice\PhpWord\Style\Tab('center', $widthcarrera/4*3),
            new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
        ]
    ]);
    $detailColLastPar = "detailColLastPar";
    $phpWord->addParagraphStyle($detailColLastPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>50,
        "tabs" => [
            //new \PhpOffice\PhpWord\Style\Tab('left', $widthcarrera/8*3),
            new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40)
        ]
    ]);
    $detailColWinnerPar = "detailColWinnerPar";
    $phpWord->addParagraphStyle($detailColWinnerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', $widthcarrera/8),
            new \PhpOffice\PhpWord\Style\Tab('right', $widthcarrera-40),
        ]
    ]);
    $detailColHorseText = "detailColHorseText";
    $phpWord->addFontStyle($detailColHorseText, [
        //"name"=>"Univers 75 Black",
        //"name"=>"Arial Black",
        "name"=>"Univers Extra Black",
        "size"=>12,
        "scale" => 100,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailColHorsePar = "detailColHorsePar";
    $phpWord->addParagraphStyle($detailColHorsePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    $actualrace = 0;
    while ($row = $rs->fetch_assoc()){
        $actualhorse = $row["horsename"];
        if ($actualrace != $row["raceid"]){
            $actualrace = intval($row["raceid"]);

            // Página
            $section = $phpWord->addSection([
                "marginTop"=>$top,
                "marginBottom"=>$bottom,
                "marginLeft"=>$left,
                "marginRight"=>$right,
                "pageSizeH"=>$height,
                "pageSizeW"=>$width,
                //"breakType"=>"continuous"
            ]);
            // Header de la carrera
            $headertab = $section->addTable([$headerTableStyle]);
            $headertab->addRow();
            $cell = $headertab->addCell($width, $headerCellStyle);
            $cell->addText("Retrospecto " . $ordinal[$row["valid"]-1] . " Válida",
                    $mainHeaderText, $mainHeaderPar);

            $detailtab = $section->addTable([$detailTableStyle]);

            // impresión de linea escondida
            $detailtab->addRow(25, ["exactHeight"=>true]);
            $cell = $detailtab->addCell($firstcolwidth, $detailHiddenCellStyle);
            $cell->addText(".", $detailHiddenText, $detailHiddenPar);
            for ($k=0; $k<5; $k++){
                $cell = $detailtab->addCell($widthcarrera, $detailHiddenCellStyle);
                $cell->addText(".", $detailHiddenText, $detailHiddenPar);
            }
    
        }

        $detailtab->addRow(800, ["exactHeight"=>true]);
        // primera columna
        $cell = $detailtab->addCell($firstcolwidth, $detailFirstCellStyle);
        $cell->addText($row["horsenumber"],
                $detailFirstColText, $detailFirstColPar);
        
        $sql =  "SELECT		RE.date, H.id horseid, H.abbr horsename, CONCAT(C.abbr, RA.number) racenmbr, D.dsc distance, IFNULL(RA.finishtime,0) finishtime, R.dividends, " .
                "           R.arrivalposition, R.position, RA.id raceid, IFNULL(B.abbr,'') bodies, J.abbr jockeyname, R.finishtime horsetime, IFNULL(R.jockeyweight,0) jockeyweight " .
                "FROM		races RA  " .
                "INNER JOIN	distances D  " .
                "ON			RA.distanceid=D.id " .
                "INNER JOIN racers R  " .
                "ON			RA.id=R.raceid " .
                "INNER JOIN horses H  " .
                "ON			R.horseid=H.id " .
                "INNER JOIN jockeys J  " .
                "ON			R.jockeyid=J.id " .
                "LEFT JOIN  bodies B  " .
                "ON			R.bodiesid=B.id " .
                "INNER JOIN reunions RE  " .
                "ON			RA.reunionid=RE.id " .
                "INNER JOIN	racecourses C  " .
                "ON			RE.racecourseid=C.id " .
                "WHERE		RA.id IN  " .
                "           ( " .
                "           SELECT      raceid " .
                "           FROM " .
                "                       (" .
                "                       SELECT     raceid, date " .
                "                       FROM       wrk_horsehistory " .
                "                       WHERE      horseid = " . $row["horseid"] . " " .
                "                       AND        raceid <> " . $actualrace . " " .
                "                       AND        date < '"   . $date . "' " .
                "                       ORDER BY   date desc " .
                "                       LIMIT 5 " .
                "                       ) A " .
                "           ORDER BY   date " .
                "           ) " .
                "ORDER BY	RE.date DESC, R.arrivalposition";
//echo($actualrace . "<br/>");
//die($sql);
        if (!$rs2 = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        $races = array();
        $lines = array();
        $raceact = "";
        $lastline = "";
        if ($row2 = $rs2->fetch_assoc()){
            $raceact = $row2["raceid"];
            $lines[] = $row2["racenmbr"] . "\t-\t" . $row2["distance"] . "\t-\t" . number_format($row2["finishtime"],1,",",".");
            if ($row2["horseid"] == $row["horseid"]){
                if ($row2["arrivalposition"] != 0){
                    $lines[] = "*" . $row2["arrivalposition"] . "\t" . $row2["horsename"] . "," . $row2["bodies"] . "\t" . $row2["jockeyweight"];
                    $lastline = $row2["jockeyname"] . "    ," .  number_format($row2["dividends"], 2, ",", ".") . "\tPP." . $row2["position"];
                }else{
                    $lastline = "RETIRADO";
                }
            }else{
                if ($row2["arrivalposition"] != 0)
                    $lines[] = $row2["horsename"] . "," . $row2["bodies"] . "\t" . $row2["jockeyweight"];
            }
            while (($row2 = $rs2->fetch_assoc())){
                if ($raceact <> $row2["raceid"]){
                    $lines[] = $lastline;
                    $races[] = $lines;
                    $lines = array();
                    $raceact = $row2["raceid"];
                    $lines[] = $row2["racenmbr"] . "\t-\t" . $row2["distance"] . "\t-\t" . number_format($row2["finishtime"],1,",",".");
                    $lastline = "";
                }
                if ($row2["horseid"] == $row["horseid"]){
                    if ($row2["arrivalposition"] != 0){
                        $lines[] = "*" . $row2["arrivalposition"] . "\t" . $row2["horsename"] . "," . $row2["bodies"] . "\t" . $row2["jockeyweight"];
                        $lastline = $row2["jockeyname"] . "    ," .  number_format($row2["dividends"], 2, ",", ".") . "\tPP." . $row2["position"];
                    }else{
                        $lastline = "RETIRADO";
                    }
                }else{
                    if ($row2["arrivalposition"] != 0)
                        if ((count($lines) < 4 && $lastline=="") || (count($lines) < 5 && $lastline!=""))
                            $lines[] = $row2["horsename"] . "," . $row2["bodies"] . "\t" . $row2["jockeyweight"];
                }

            }
            $lines[] = $lastline;
            $races[] = $lines;
        }

        // Columnas carreras
        $cont=true;
        for ($i=0; $i<5 && $cont; $i++){
            // armar datos de la carrera
            if (count($races) >= ($i+1)){
                $cell = $detailtab->addCell($widthcarrera, $detailCellStyle);
                foreach($races[$i] as $j=>$line){
                    switch ($j){
                        case 0:
                            $cell->addText($line,
                                    $detailBoldColText, $detailColFirstPar);
                            break;
                        case 5:
                            if ($line == "RETIRADO")
                                $cell->addText($line,
                                        $detailBoldRetColText, $detailColLastPar);
                            else
                                $cell->addText($line,
                                        $detailColLastText, $detailColLastPar);
                            break;
                        case 4:
                            if ($races[$i][5] == "RETIRADO"){
                                $cell->addText("\t" . $actualhorse,
                                        $detailColWinnerText, $detailColWinnerPar);
                                break;
                            }
                        default:
                                if (substr($line, 0, 1) == "*")
                                    $cell->addText(substr($line,1),
                                            $detailColWinnerText, $detailColWinnerPar);
                                else
                                    $cell->addText($line,
                                            $detailColText, $detailColPar);
                    }
                }
            }else{
                // cambiar spam
                $detailCellSpamStyle = [
                    "gridSpan" => 5-$i,
                    "valign" => "center",
                    "borderBottomSize" => 4,
                    "borderTopSize" => 0,
                    "borderTopStyle" => Border::NONE,
                    "borderLeftSize" => 0,
                    "borderLeftStyle" => Border::NONE,
                    "borderRightSize" => 0,
                    "borderRightStyle" => Border::NONE,
                ];
                $cell = $detailtab->addCell($widthcarrera, $detailCellSpamStyle);
                if (5-$i > 1){
                    $cell->addText($row["horsename"] . chr(194) . chr(160) . chr(194) . chr(160),
                            $detailColHorseText, $detailColHorsePar);
                }
                $cont = false;  // forzar salida
            }
        }
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            \PhpOffice\PhpWord\Settings::setPdfRendererOptions([
                'font' => 'Helvetica',
            ]);
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>