<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $cyan = "00AEEF";

    // parametros opcionales
    $racefilter = "";
//    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
//        $raceidfrom = intval($_REQUEST["raceidfrom"]);
//        $raceidto = intval($_REQUEST["raceidto"]);
//        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
//        if (!$rs = $db->query($sql))
//            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
//        if (!$row = $rs->fetch_assoc())
//            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
//        $racenumberfrom = $row["number"];
//        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
//        if (!$rs = $db->query($sql))
//            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
//        if (!$row = $rs->fetch_assoc())
//            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
//        $racenumberto = $row["number"];
//        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
//    }

    isSessionValid($db, $sessionid);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr, DAYOFWEEK(R.date) dow " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];
    $dow = ["DOMINGO", "LUNES", "MARTES", "MIÉRCOLES", "JUEVES", "VIERNES", "SÁBADO"];
    $dayname = $dow[$row["dow"]-1];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid>0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr . "6M" . $row["num"] . "." . $outputformat;

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $height = 1.7*$pulgada;  // 1440 twip = 1 pulgada
    $width = 3*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 200;
  
    $sql =  "SELECT 	RA.valid, " .
            "           JSON_EXTRACT(IFNULL(F.racers, '[]'), '$[*].id') racers, " .
            "           JSON_EXTRACT(IFNULL(F.racers, '[]'), '$[*].forecast') forecasts " .
            "FROM 		reunions RE  " .
            "INNER JOIN	races RA " .
            "ON			RE.id=RA.reunionid " .
            "LEFT JOIN	forecasts F " .
            "ON			RA.id=F.raceid " .
            "WHERE		RE.id=" . $reunionid . " " . 
            $racefilter .
            "AND		RA.valid<>0 " .
            "AND        F.magazineid=" . $magazineid . " " .
            "ORDER BY	RA.valid ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // cargar carreras
    $races = array();
    $incomplete = false;
    while (($row = $rs->fetch_assoc()) && !$incomplete){
        if (nvl($row["racers"], "") != "" && nvl($row["forecasts"],"") != ""){
            $racers = explode(",", preg_replace("/[^0-9,]+/", "", $row["racers"]));
            $forecasts = explode(",", preg_replace("/[^0-9,]+/", "", $row["forecasts"]));
            $allracers = array();
            // quitar los ceros
            foreach($forecasts as $i=>$fc){
                if ($fc!=0){
                    // buscar datos de caballos
                    $sql =  "SELECT     H.dsc, H.abbr, R.number " .
                            "FROM       racers R " . 
                            "INNER JOIN horses H " . 
                            "ON         R.horseid=H.id " .
                            "WHERE      R.id='" . $racers[$i] . "'";
                    if (!$rs2 = $db->query($sql))
                        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
                    $horsename="Falta nombre";
                    $horseabbr="Falta abbr";
                    $horsenmbr="Falta número";
                    if ($row2 = $rs2->fetch_assoc()){
                        $horsename=$row2["dsc"];
                        $horseabbr=$row2["abbr"];
                        $horsenmbr=$row2["number"];
                    }
                    $allracers[] = ["racer"=>$racers[$i], 
                                    "horsename"=>$horsename,
                                    "horseabbr"=>$horseabbr,
                                    "horsenmbr"=>$horsenmbr,
                                    "forecast"=>$fc];
                }
            }
            usort($allracers, function ($a, $b) {
                return $a['forecast'] - $b['forecast'];
            });
            $races[] = $allracers;
        }else{
            $incomplete = true;
        }
    }

    // ESTILOS
    // Celdas
    $headerCellStyle = [
        "gridSpan" => 6,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        "color"=>"FFFFFF",
        "bgColor"=>$cyan,
    ];
    $detailEmptyCellStyle = [
        "valign" => "top",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        "color"=>"FFFFFF",
        "bgColor"=>$cyan,
    ];
    $detailCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
        "color"=>"000000",
        "bgColor"=>"FFFFFF",
    ];

    // Tablas
    $mainTableStyle = "mainTableStyle";
    $phpWord->addTableStyle($mainTableStyle,[
            "width" => $width,
            "borderColor" => "FFFFFF",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 20,
        ],$detailCellStyle,$detailCellStyle);


    // Textos
    $mainHeaderText = "mainHeaderText";
    $phpWord->addFontStyle($mainHeaderText, [
        "name"=>"Univers 65",
        "size"=>12.5,
        "bold"=>false,
        "bgColor"=>$cyan,
        "color"=>"FFFFFF",
    ]);
    $mainHeaderPar = "mainHeaderPar";
    $phpWord->addParagraphStyle($mainHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "shading"=>["fill"=>$cyan],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailNumberText = "detailNumberText";
    $phpWord->addFontStyle($detailNumberText, [
        //"name"=>"Univers 65",
        //"name"=>"Arial Black",
        "name"=>"Univers 65",
        "size"=>25,
        "scale" => 60,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $detailNumberPar = "detailNumberPar";
    $phpWord->addParagraphStyle($detailNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-30,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detail5y6Text = "detail5y6Text";
    $phpWord->addFontStyle($detail5y6Text, [
        //"name"=>"Univers 65",
        //"name"=>"Arial Rounded MT Bold",
        "name"=>"Univers 65",
        "size"=>8,
        "scale" => 60,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detail5y6Par = "detail5y6Par";
    $phpWord->addParagraphStyle($detail5y6Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailHorsesText = "detailHorsesText";
    $phpWord->addFontStyle($detailHorsesText, [
        //"name"=>"Helvetica_Condenced-Normal",
        "name"=>"Helvetica",
        "scale" => 85,
        "spacing"=>-5,
        "size"=>5.5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"#000000"
    ]);
    $detailHorsesPar = "detailHorsesPar";
    $phpWord->addParagraphStyle($detailHorsesPar, [
        "spaceAfter"=>0,
        //"spacing"=> 0.9,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('right', ($width/3/5*4)-50)
        ]
    ]);

    // validar que todas las carreras tengas 6 favoritos
    $somewithout6 = false;
    foreach($races as $race)
        if (count($race) != 6)
            $somewithout6 = true;

    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width,
        //"breakType"=>"continuous"
    ]);
    if (!$somewithout6 && !$incomplete){
        $table = $section->addTable($mainTableStyle);
        $table->addRow();
        $cell = $table->addCell($width,$headerCellStyle);
        $cell->addText("LOS MEJORES SEIS DEL " . $dayname,
                        $mainHeaderText, $mainHeaderPar);

        for ($race=0; $race<count($races); $race++){
            if ($race % 3 == 0)
                $table->addRow();

            // Numero de la carrera
            $cell = $table->addCell($width/3/5,$detailEmptyCellStyle);
            $cell->addText($race+1, $detailNumberText, $detailNumberPar);
            $cell->addText('"5y6"', $detail5y6Text, $detail5y6Par);

            // Caballos
            $cell = $table->addCell($width/3/5*4,$detailCellStyle);

            foreach($races[$race] as $horses){
                $cell->addText($horses["horsename"] . "\t" . $horses["horsenmbr"], 
                    $detailHorsesText, $detailHorsesPar);
            }
        }
    }else{
        // Titulo
        $section->addText("FALTAN PRONOSTICOS PARA ESTA REUNION",
                        [
                            "name"=>"Univers 55",
                            "scale" => 80,
                            "size"=>12,
                            "bold"=>false,
                            "color"=>"#FF0000",
                            "bgColor"=>$cyan
                        ],
                        [
                            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 
                            "shading"=>["fill"=>$cyan],
                            "spaceBefore"=>0,
                            "spaceAfter"=>0,
                        ]
        );
    }
    
    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>