<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr, DAYOFWEEK(R.date) dow " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
    $dayofweek = $dow[$row["dow"]-1];
    $racecourse = $row["dsc"];
    $racecourseid = $row["racecourseid"];
    $rcabbr = $row["rcabbr"];
    $date = $row["date"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid>0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr . "CE" . $row["num"] . "." . $outputformat;

    $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
    //$datefrom = "1900-01-01";
    // calcular inicio del cuatrimestre
    $actualmonth = intval(date('m', strtotime($date)));
    if ($actualmonth <= 4)
        $datefrom4 = "01";
    else if ($actualmonth <= 8)
        $datefrom4 = "05";
    else if ($actualmonth <= 12)
        $datefrom4 = "09";
    $datefrom4 = date('Y', strtotime($date)) . "-" . $datefrom4 . "-01";
    if ($racecourseid == 2)
        $datefrom = $datefrom4;
    $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));
    $sql =  "SELECT 	T.fullname trainername, RA.valid, GROUP_CONCAT(H.dsc) horsename, " .
            "           SUM(ST.firstplace) firstplace, SUM(ST.totalraces) totalraces " .
            "FROM 		racers R  " .
            "LEFT JOIN  (SELECT T.trainerid, SUM(T.totalraces5) totalraces, SUM(T.firstplace5) firstplace FROM (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_trainers T WHERE T.racecourseid=" . $racecourseid . " GROUP BY T.trainerid) ST " . 
            "ON         R.trainerid=ST.trainerid " .
            "INNER JOIN	(SELECT id, CONCAT(SUBSTRING_INDEX(lastnames, ' ', 1), ' ', SUBSTR(names, 1, 1), '.', IF (LENGTH(TRIM(SUBSTR(names, LOCATE(' ', names))))>0, SUBSTR(CONCAT(TRIM(SUBSTR(names, LOCATE(' ', names))), '.'), 1, 1), '')) fullname FROM trainers) T " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN horses H " .
            "ON			R.horseid=H.id " .
            "INNER JOIN	races RA  " .
            "ON			R.raceid=RA.id  " .
            "WHERE		RA.reunionid=" . $reunionid . " " . 
            "AND		RA.valid>0 " .
            "GROUP BY	T.fullname, RA.valid " . 
            "ORDER BY	T.fullname, RA.valid ";

    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $height = 8.07*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $detailwidth = $width*0.75-50;
    $blank = chr(194) . chr(160);

    // colores
    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";

    // ESTILOS
    // Celdas
    $headerCellStyle = [
        "bgColor"=>$cyanlight,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $blankCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $detailCellStyle = [
        "valign" => "center",
        "borderRightSize" => 1,
        "borderRightColor" => "000000",
        "borderLeftSize" => 1,
        "borderLeftColor" => "000000",
        "borderTopSize" => 0,
        "borderTopColor" => "000000",
        "borderBottomSize" => 1,
        "borderBottomColor" => "000000",
        //"borderStyle" => Border::OUTSET,
    ];

    // Tablas
    $headerTableStyle = "headerTableStyle";
    $phpWord->addTableStyle($headerTableStyle,[
            "width" => $width,
            "borderColor" => "000000",
            "borderSize" => 8,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $headerCellStyle, $headerCellStyle);
    $detailTableStyle = "detailTableStyle";
    $phpWord->addTableStyle($detailTableStyle,[
            "width" => $detailwidth,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 10,
            "cellSpacing" => 0,
        ], $detailCellStyle, $detailCellStyle);

    // Textos
    $leftHeaderText = "leftHeaderText";
    $phpWord->addFontStyle($leftHeaderText, [
        //"name"=>"Helvetica Rounded",
        "name"=>"Arial Rounded",
        "size"=>20,
        "scale" => 130,
        "spacing"=>0,
        "allCaps"=>true,
        "bold"=>false,
        "italic"=>true,
        "color"=>$cyan,
    ]);
    $leftHeaderPar = "leftHeaderPar";
    $phpWord->addParagraphStyle($leftHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $rightHeaderText = "rightHeaderText";
    $phpWord->addFontStyle($rightHeaderText, [
        //"name"=>"Times Roman SC & OSF",
        //"name"=>"Times New Roman",
        "name"=>"Arial Rounded MT Bold",
        "size"=>13,
        "scale" => 120,
        "spacing"=>0,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $rightHeaderPar = "rightHeaderPar";
    $phpWord->addParagraphStyle($rightHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>20,
    ]);
    $detailNameText = "detailNameText";
    $phpWord->addFontStyle($detailNameText, [
        //"name"=>"Univers 55",
        //"name"=>"Helvetica Neue",
        //"name"=>"Arial",
        //"name"=>"Calibri",
        "name"=>"Univers 55",
        "size"=>6,
        "scale" => 80,
        "spacing"=>0,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $titText = "titText";
    $phpWord->addFontStyle($titText, [
        //"name"=>"Univers 55",
        //"name"=>"Helvetica Neue",
        //"name"=>"Arial Rounded MT Bols",
        "name"=>"Univers 55",
        "size"=>6,
        "scale" => 80,
        "spacing"=>0,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailText = "detailText";
    $phpWord->addFontStyle($detailText, [
        //"name"=>"Univers 55",
        //"name"=>"Helvetica Neue",
        //"name"=>"Arial",
        //"name"=>"Calibri",
        "name"=>"Univers 55",
        "size"=>5.5,
        "scale" => 75,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $detailRedText = "detailRedText";
    $phpWord->addFontStyle($detailRedText, [
        "name"=>"Univers 55",
        "size"=>5.5,
        "scale" => 70,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $titCenterPar = "titCenterPar";
    $phpWord->addParagraphStyle($titCenterPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>0,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
    $detailLeftPar = "detailLeftPar";
    $phpWord->addParagraphStyle($detailLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>-50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $detailCenterPar = "detailCenterPar";
    $phpWord->addParagraphStyle($detailCenterPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>-50,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);


    // Página
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width+50,
        //"breakType"=>"continuous"
    ]);

    // header principal
    $headertab = $section->addTable($headerTableStyle);
    $headertab->addRow(80);
    $cell = $headertab->addCell($width*0.6, $headerCellStyle);
    $cell->addText("ENTRENADORES",
            $leftHeaderText, $leftHeaderPar);
    $cell = $headertab->addCell($width*0.4, $headerCellStyle);
    $cell->addText("Sus compromisos" . $blank,
            $rightHeaderText, $rightHeaderPar);
    $cell->addText("en el 5 y 6 " . $dayofweek . $blank,
            $rightHeaderText, $rightHeaderPar);
            
    // Tabla de detalle
    $detailtab = $section->addTable($detailTableStyle);
    // encabezados
    $C0 = $width*0.25-25;
    $C1 = (($detailwidth)/8)*2*0.7;
    $C2 = (($detailwidth)/8)*2*0.3;
    $C3to6 = ($detailwidth)/8;
    $detailtab->addRow(80);
    $cell = $detailtab->addCell($C0, $blankCellStyle);
    $cell->addText($blank, $titText, $detailLeftPar);
    $cell = $detailtab->addCell($C1, $detailCellStyle);
    $cell->addText("NOMBRES", $titText, $titCenterPar);
    $cell = $detailtab->addCell($C2, $detailCellStyle);
    $cell->addText("5 y 6", $titText, $titCenterPar);
    for ($i=1; $i<=6; $i++){
        $cell = $detailtab->addCell($C3to6, $detailCellStyle);
        $cell->addText($i . "° VÁLIDA", $titText, $titCenterPar);
    }

    // Detalles
    $actualtrainer = "";
    $nextlines = [];
    while ($row = $rs->fetch_assoc()){
        if ($actualtrainer !== $row["trainername"]){
            // completar las 6 validas
            if($actualtrainer != ""){
                for ($i=$j; $i<=6; $i++){
                    $cell = $detailtab->addCell($C3to6, $detailCellStyle);
                    $cell->addText($blank, $detailText, $detailCenterPar);
                }
            }
            // imprimir lineas adicionales
            if (count($nextlines) > 0){
                for ($l=0; $l<count($nextlines); $l++){
                    $detailtab->addRow(80);
                    $cell = $detailtab->addCell($C0, $blankCellStyle);
                        $cell->addText($blank, $detailText, $detailLeftPar);
                    $cell = $detailtab->addCell($C1, $detailCellStyle);
                        $cell->addText($blank, $detailNameText, $detailLeftPar);
                    $cell = $detailtab->addCell($C2, $detailCellStyle);
                        $cell->addText($blank, $detailNameText, $detailCenterPar);
                    for ($v=0; $v<6; $v++){
                        $cell = $detailtab->addCell($C3to6, $detailCellStyle);
                            $cell->addText($nextlines[$l][$v], strlen($nextlines[$l][$v]) > 13 ? $detailRedText : $detailText, $detailLeftPar);
                    }
                }
            }


            $j=1;
            $detailtab->addRow(80);
            $nextlines = [];
            $actualtrainer = $row["trainername"];

            $cell = $detailtab->addCell($C0, $blankCellStyle);
                $cell->addText($blank, $detailText, $detailLeftPar);
            $cell = $detailtab->addCell($C1, $detailCellStyle);
                $cell->addText($actualtrainer, $detailNameText, $detailLeftPar);
            $cell = $detailtab->addCell($C2, $detailCellStyle);
                $cell->addText($row["totalraces"] . "-" . $row["firstplace"], $detailNameText, $detailCenterPar);
        }

        while ($row["valid"] != $j && $j < 7){
            $cell = $detailtab->addCell($C3to6, $detailCellStyle);
            $cell->addText($blank, $detailText, $detailCenterPar);
            $j++;
        }
        $cell = $detailtab->addCell($C3to6, $detailCellStyle);
        $caballos = explode(",", $row["horsename"]);
        $cell->addText(mb_strtoupper($caballos[0]), strlen(mb_strtoupper($caballos[0])) > 13 ? $detailRedText : $detailText, $detailLeftPar);
        // armar lineas adicionales
        if (count($caballos) > 1){
            for ($l=1; $l<count($caballos); $l++){
                if (count($nextlines)<$l)
                    $nextlines[] = [$blank,$blank,$blank,$blank,$blank,$blank];
                $nextlines[$l-1][$j-1] = mb_strtoupper($caballos[$l]);
            }
        }
            
        $j++;
    }
    // completar las 6 validas
    if($actualtrainer != ""){
        for ($i=$j; $i<=6; $i++){
            $cell = $detailtab->addCell($C3to6, $detailCellStyle);
            $cell->addText($blank, $detailText, $detailCenterPar);
        }
    }
    // imprimir lineas adicionales
    if (count($nextlines) > 0){
        for ($l=0; $l<count($nextlines); $l++){
            $detailtab->addRow(80);
            $cell = $detailtab->addCell($C0, $blankCellStyle);
                $cell->addText($blank, $detailText, $detailLeftPar);
            $cell = $detailtab->addCell($C1, $detailCellStyle);
                $cell->addText($blank, $detailNameText, $detailLeftPar);
            $cell = $detailtab->addCell($C2, $detailCellStyle);
                $cell->addText($blank, $detailNameText, $detailCenterPar);
            for ($v=0; $v<6; $v++){
                $cell = $detailtab->addCell($C3to6, $detailCellStyle);
                    $cell->addText($nextlines[$l][$v], strlen($nextlines[$l][$v]) > 13 ? $detailRedText : $detailText, $detailLeftPar);
            }
        }
    }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>