<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
        // corregir decodificar apóstrofes y comillas en el nombre
        $filtro = str_replace("/*.*/", "\'", $filtro);
        $filtro = str_replace("/*:*/", "\`", $filtro);
    }
    $genderid = "";
    if (isset($_REQUEST["genderid"])){
        $genderid = preg_replace("/[^YC]+/", "", $_REQUEST["genderid"]);
    }
    $furid = 0;
    if (isset($_REQUEST["furid"])){
        $furid = intval($_REQUEST["furid"]);
    }
    $harasid = 0;
    if (isset($_REQUEST["harasid"])){
        $harasid = intval($_REQUEST["harasid"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }
    $fullsearch = 0;
    if (isset($_REQUEST["fullsearch"])){
        $fullsearch = intval($_REQUEST["fullsearch"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 460, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        if ($fullsearch == 1){
            $filter .= "(";
            $filter .= "    H.dsc like '%" . $filtro . "%' ";
            $filter .= "OR  H.abbr like '%" . $filtro . "%' ";
            $filter .= "OR  H.origin like '%" . $filtro . "%' ";
            $filter .= "OR  F.dsc like '%" . $filtro . "%' ";
            $filter .= "OR  F.abbr like '%" . $filtro . "%' ";
            $filter .= "OR  A.dsc like '%" . $filtro . "%' ";
            $filter .= "OR  A.abbr like '%" . $filtro . "%' ";
            $filter .= "OR  H.fathername like '%" . $filtro . "%' ";
            $filter .= "OR  H.fathergfname like '%" . $filtro . "%' ";
            $filter .= "OR  H.fathergmname like '%" . $filtro . "%' ";
            $filter .= "OR  H.mothername like '%" . $filtro . "%' ";
            $filter .= "OR  H.mothergfname like '%" . $filtro . "%' ";
            $filter .= "OR  H.mothergmname like '%" . $filtro . "%' ";
            $filter .= "OR  IF(H.gender='Y', 'Yegua', 'Caballo') like '%" . $filtro . "%' ";
            $filter .= "OR  IF(H.status='1', ' Activo', ' Inactivo') like '% " . $filtro . "%' ";
            $filter .= "OR  CONVERT(DATEDIFF(NOW(), H.birthdate)/365, UNSIGNED) like '" . $filtro . "' ";
            $filter .= ")";
        }else{
            $filter .= "(";
            $filter .= "    H.dsc like '%" . $filtro . "%' ";
            $filter .= "OR  H.abbr like '%" . $filtro . "%' ";
            $filter .= "OR  H.id = " . intval($filtro) . " ";
            $filter .= ")";
        }
    }

    // filtro de status
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " H.status = " . ($statusid == 1 ? "1" : "0");
    }
    // filtro de sexo
    if ($genderid != ""){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " H.gender = '" . $genderid . "'";
    }
    // filtro de pelaje
    if ($furid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " F.id = " . $furid;
    }
    // filtro de haras
    if ($harasid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " A.id = " . $harasid;
    }

    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " H.createdat ";
            break;
        case 2:
            $order = " H.modifiedat ";
            break;
        case 3:
            $order = " H.dsc ";
            break;
        case 4:
            $order = " H.abbr ";
            break;
        case 5:
            $order = " DATEDIFF(NOW(),H.birthdate) ";
            break;
        case 6:
            $order = " H.gender ";
            break;
        case 7:
            $order = " F.dsc ";
            break;
        case 8:
            $order = " H.origin ";
            break;
        case 9:
            $order = " A.dsc ";
            break;
        case 10:
            $order = " H.status ";
            break;
        case 11:
            $order = " H.status DESC, H.dsc ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(", ", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     H.id, H.dsc, H.abbr, H.status, H.gender, IF(H.gender='Y', 'Yegua', 'Caballo') genderdsc, " .
            "           IF(H.status='1', 'Activo', 'Inactivo') statusdsc, " .
            "           IFNULL(H.origin, '') origin, H.obs, H.createdat, H.modifiedat, " .
            "           H.fatherid, H.fathername, H.motherid, H.mothername, H.fathergfname, H.fathergmname,  " .
            "           H.mothergfname, H.mothergmname, DATEDIFF(NOW(), H.birthdate)/365 age, " .
            "           F.id fid, F.dsc fdsc, F.abbr fabbr,  " .
            "           A.id aid, A.dsc adsc, A.abbr aabbr  " .
            "FROM       horses H " .
            "INNER JOIN furs F " .
            "ON         H.furid=F.id " .
            "INNER JOIN haras A " . 
            "ON         H.harasid=A.id " .
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->name = $row["dsc"];
        $record->abbr = $row["abbr"];
        $record->origin = $row["origin"];
        $record->age = (integer) $row["age"];
        $record->status = new stdClass;
        $record->status->id = (integer) $row["status"];
        $record->status->name = $row["statusdsc"]; //$record->status->id==0 ? "Inactivo" : "Activo";
        $record->gender = new stdClass;
        $record->gender->id = $row["gender"];
        $record->gender->name = $row["genderdsc"]; //$record->gender->id=="Y" ? "Yegua" : "Caballo";
        $record->haras = new stdClass;
        $record->haras->id = (integer) $row["aid"];
        $record->haras->name = $row["adsc"];
        $record->fur = new stdClass;
        $record->fur->id = (integer) $row["fid"];
        $record->fur->name = $row["fdsc"];

        $out->records[] = $record;
    }

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 460);
    $access["update"] = tienePrivilegio($db, $sessionid, 461);
    $access["create"] = tienePrivilegio($db, $sessionid, 462);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 463);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>