<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 310, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     D.id, D.dsc, D.status, " .
            "           D.createdat created, DATE_FORMAT(D.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           D.modifiedat modified, DATE_FORMAT(D.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
            "FROM       distances D " .
            "WHERE      D.id = " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 310);
    $access["update"] = tienePrivilegio($db, $sessionid, 311);
    $access["create"] = tienePrivilegio($db, $sessionid, 312);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 313);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>