<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios id,sessionid"));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
        
    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 313))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // validar que exista el estado
    $sql =  "SELECT  COUNT(*) cnt, MIN(dsc) dsc " .
            "FROM    distances " .
            "WHERE   id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    $row = $rs->fetch_assoc();
    if ($row["cnt"]<=0)
        badEnd("204", array("msg"=>"Distancia no encontrada"));
    $dsc = $row["dsc"];

    //Preparando la salida
    $out = new StdClass;
    $out->id = $id;

    // eliminar la distancia de las sedes en caso de encontrarla
    $sql = "SELECT  id, distances " .
            "FROM   racecourses";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));

    while ($row = $rs->fetch_assoc()){
        $newdistances = array();
        $distances = json_decode($row["distances"]);
        $recordsourceid = json_decode($row["id"]);
        foreach ($distances as $distance){
            if ($distance->id == $id)
                badEnd("304", array("msg"=>"Existen dependencias que no permiten eliminar el registro"));
            else
                $newdistances[] = $distance;
        }
        $sql = "UPDATE racecourses set distances='" . json_encode($newdistances) . "' WHERE id=" . $recordsourceid;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    }
        
    $sql =  "DELETE " .
            "FROM    distances " .
            "WHERE   id=" . $id;
    if (!$db->query($sql))
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar el registro"));
        else
            badEnd("500", array("msg"=>$db->error));
    if ($db->affected_rows > 0){
        $out->id = $id;
    }else{
        badEnd("204", array("msg"=>"No se consiguió borrar el registro"));
    }

    setAudit($db, "Distancias", $sessionid, "Se eliminó la distancia \'" . $dsc . "\'");

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
