<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $stateid = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 210, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     S.id staid, S.dsc stadsc, IFNULL(M.id, 0) munid, IFNULL(M.dsc, '') mundsc, S.status stastatus, M.status munstatus, " .
            "           S.createdat created, DATE_FORMAT(S.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           S.modifiedat modified, DATE_FORMAT(S.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
            "FROM       states S " .
            "LEFT JOIN  municipalities M " .
            "ON         S.id = M.stateid " . 
            "WHERE      S.id = " . $stateid . " " . 
            "ORDER BY   M.dsc";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $first = true;
    while ($row = $rs->fetch_assoc()){
        if ($first){
            $entry = new stdClass;
            $entry->id = (integer) $row["staid"];
            $entry->name = $row["stadsc"];
            $entry->status = new stdClass;
            $entry->status->id = (integer) $row["stastatus"];
            $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
            $entry->created = new stdClass;
            $entry->created->date = $row["created"];
            $entry->created->formatted = $row["createdfmt"];
            $entry->modified = new stdClass;
            $entry->modified->date = $row["modified"];
            $entry->modified->formatted = $row["modifiedfmt"];
            $entry->municipalities = array();
            $first = false;
        }
        $mun = new stdClass;
        $mun->id = (integer) $row["munid"];
        $mun->name = $row["mundsc"];
        $mun->status = new stdClass;
        $mun->status->id = (integer) $row["munstatus"];
        $mun->status->name = $mun->status->id==0 ? "Inactivo" : "Activo";

        $entry->municipalities[] = $mun;
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 212);
    $access["delete"] = tienePrivilegio($db, $sessionid, 213);
    $access["update"] = tienePrivilegio($db, $sessionid, 211);
    $access["read"] =   tienePrivilegio($db, $sessionid, 210);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>