<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "name", "stateid", "status");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $name = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["name"]);
    $stateid = intval($_REQUEST["stateid"]);
    $status = intval($_REQUEST["status"]);

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));

    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 222, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO municipalities " .
                "       (dsc, stateid, status) " .
                "VALUES (" .
                "        '" . $name . "'," .
                "        '" . $stateid . "', " .
                "        '" . $status . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Municipios", $sessionid, "Se incluyó el municipio \'" . $name . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 221, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE municipalities " .
                "SET    dsc = '" . $name . "'," .
                "       stateid = '" . $stateid . "', " .
                "       status = '" . $status . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Municipios", $sessionid, "Se actualizó el municipio \'" . $name . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>